/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class JAICreateImage
extends AbstractSource {
    private static final long serialVersionUID = -5718059337341470131L;
    protected int m_Width;
    protected int m_Height;
    protected Color m_Background;
    protected Token m_OutputToken;

    public String globalInfo() {
        return "Generates an empty image with the specified dimensions.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)this.getDefaultWidth(), (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)this.getDefaultHeight(), (Number)1, null);
        this.m_OptionManager.add("background", "background", (Object)this.getDefaultBackground());
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_Width);
        result = result + " x ";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_Height);
        return result;
    }

    public int getDefaultWidth() {
        return 800;
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the image.";
    }

    public int getDefaultHeight() {
        return 600;
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the image.";
    }

    public Color getDefaultBackground() {
        return Color.WHITE;
    }

    public void setBackground(Color value) {
        this.m_Background = value;
        this.reset();
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public String backgroundTipText() {
        return "The background color of the image.";
    }

    public Class[] generates() {
        return new Class[]{BufferedImageContainer.class};
    }

    protected String doExecute() {
        BufferedImage image = new BufferedImage(this.m_Width, this.m_Height, 1);
        Graphics2D g = image.createGraphics();
        g.fillRect(0, 0, this.m_Width, this.m_Height);
        g.dispose();
        BufferedImageContainer cont = new BufferedImageContainer();
        cont.setImage((Object)image);
        this.m_OutputToken = new Token((Object)cont);
        return null;
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

