/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.image.BufferedImageContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class JAIReader
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 7466006970025235243L;

    public String globalInfo() {
        return "Reads any file format that Java Advanced Imaging (JAI) can read.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{BufferedImageContainer.class};
    }

    protected String doExecute() {
        String result = null;
        RenderedOp op = this.m_InputToken.getPayload() instanceof String ? JAI.create((String)"fileload", (Object)new PlaceholderFile((String)this.m_InputToken.getPayload()).getAbsolutePath()) : JAI.create((String)"fileload", (Object)((File)this.m_InputToken.getPayload()).getAbsolutePath());
        BufferedImage image = null;
        if (op != null) {
            image = op.getAsBufferedImage();
        }
        if (image != null) {
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setImage((Object)image);
            if (this.m_InputToken.getPayload() instanceof File) {
                cont.getReport().setStringValue("Filename", ((File)this.m_InputToken.getPayload()).getAbsolutePath());
            } else {
                cont.getReport().setStringValue("Filename", this.m_InputToken.getPayload().toString());
            }
            this.m_OutputToken = new Token((Object)cont);
        } else {
            result = "Failed to read image from: " + this.m_InputToken.getPayload();
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

