/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.draw;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.transformer.draw.AbstractColorStrokeDrawOperation;
import adams.gui.core.ColorHelper;
import adams.gui.core.GUIHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class Line
extends AbstractColorStrokeDrawOperation {
    private static final long serialVersionUID = -1242368406478391978L;
    protected int m_X1;
    protected int m_Y1;
    protected int m_X2;
    protected int m_Y2;

    public String globalInfo() {
        return "Draws a line between the given start and end coordinates.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x1", "X1", (Object)1, (Number)1, null);
        this.m_OptionManager.add("y1", "Y1", (Object)1, (Number)1, null);
        this.m_OptionManager.add("x2", "X2", (Object)10, (Number)1, null);
        this.m_OptionManager.add("y2", "Y2", (Object)10, (Number)1, null);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"X1", (Object)this.m_X1, (String)"X1: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"Y1", (Object)this.m_Y1, (String)", Y1: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"X2", (Object)this.m_X2, (String)", X2: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"Y2", (Object)this.m_Y2, (String)", Y2: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"color", (Object)ColorHelper.toHex((Color)this.m_Color), (String)", Color: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"strokeThickness", (Object)Float.valueOf(this.m_StrokeThickness), (String)", Stroke: ");
        return result;
    }

    public void setX1(int value) {
        if (value > 0) {
            this.m_X1 = value;
            this.reset();
        } else {
            this.getLogger().severe("X1 must be >0, provided: " + value);
        }
    }

    public int getX1() {
        return this.m_X1;
    }

    public String X1TipText() {
        return "The X position of the start of the line (1-based).";
    }

    public void setY1(int value) {
        if (value > 0) {
            this.m_Y1 = value;
            this.reset();
        } else {
            this.getLogger().severe("Y1 must be >0, provided: " + value);
        }
    }

    public int getY1() {
        return this.m_Y1;
    }

    public String Y1TipText() {
        return "The Y position of the start of the line (1-based).";
    }

    public void setX2(int value) {
        if (value > 0) {
            this.m_X2 = value;
            this.reset();
        } else {
            this.getLogger().severe("X2 must be >0, provided: " + value);
        }
    }

    public int getX2() {
        return this.m_X2;
    }

    public String X2TipText() {
        return "The X position of the end of the line (1-based).";
    }

    public void setY2(int value) {
        if (value > 0) {
            this.m_Y2 = value;
            this.reset();
        } else {
            this.getLogger().severe("Y2 must be >0, provided: " + value);
        }
    }

    public int getY2() {
        return this.m_Y2;
    }

    public String Y2TipText() {
        return "The Y position of the end of the line (1-based).";
    }

    @Override
    protected String doDraw(BufferedImage image) {
        String result = null;
        if (this.m_X1 > image.getWidth()) {
            result = "X1 is larger than image width: " + this.m_X1 + " > " + image.getWidth();
        } else if (this.m_Y1 > image.getHeight()) {
            result = "Y1 is larger than image height: " + this.m_Y1 + " > " + image.getHeight();
        } else if (this.m_X2 > image.getWidth()) {
            result = "X2 is larger than image width: " + this.m_X2 + " > " + image.getWidth();
        } else if (this.m_Y2 > image.getHeight()) {
            result = "Y2 is larger than image height: " + this.m_Y2 + " > " + image.getHeight();
        }
        if (result == null) {
            Graphics g = image.getGraphics();
            g.setColor(this.m_Color);
            GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setStroke(new BasicStroke(this.m_StrokeThickness));
            }
            g.drawLine(this.m_X1, this.m_Y1, this.m_X2, this.m_Y2);
        }
        return result;
    }
}

