/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.flattener.AbstractBoofCVFlattener;
import adams.data.boofcv.flattener.Pixels;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import adams.data.boofcv.transformer.Gray8;
import adams.data.conversion.BufferedImageToBoofCV;
import adams.data.conversion.Conversion;
import adams.data.jai.transformer.AbstractJAITransformer;
import adams.data.jai.transformer.Resize;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.BoofCVFlattener;
import adams.flow.transformer.BoofCVTransformer;
import adams.flow.transformer.Convert;
import adams.flow.transformer.JAIReader;
import adams.flow.transformer.JAITransformer;
import adams.flow.transformer.WekaInstanceDumper;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BoofCVTransformerTest
extends AbstractFlowTest {
    public BoofCVTransformerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("adams_logo.png");
        this.m_TestHelper.copyResourceToTmp("adams_icon.png");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("adams_logo.png");
        this.m_TestHelper.deleteFileFromTmp("adams_icon.png");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier mfs = new FileSupplier();
        mfs.setFiles(new PlaceholderFile[]{new TmpFile("adams_logo.png"), new TmpFile("adams_icon.png")});
        JAIReader ir = new JAIReader();
        JAITransformer itr = new JAITransformer();
        Resize res = new Resize();
        res.setWidth(16.0);
        res.setHeight(16.0);
        itr.setTransformAlgorithm((AbstractJAITransformer)res);
        BufferedImageToBoofCV bi2bcv = new BufferedImageToBoofCV();
        bi2bcv.setImageType(BoofCVImageType.SIGNED_INT_16);
        Convert con = new Convert();
        con.setConversion((Conversion)bi2bcv);
        BoofCVTransformer btr = new BoofCVTransformer();
        btr.setTransformAlgorithm((AbstractBoofCVTransformer)new Gray8());
        BoofCVFlattener ifl = new BoofCVFlattener();
        Pixels pix = new Pixels();
        ifl.setFlattenAlgorithm((AbstractBoofCVFlattener)pix);
        WekaInstanceDumper id = new WekaInstanceDumper();
        id.setOutputPrefix((PlaceholderFile)new TmpFile("dumpfile"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{mfs, ir, itr, con, btr, ifl, id});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.arff"));
    }

    public static Test suite() {
        return new TestSuite(BoofCVTransformerTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BoofCVTransformerTest.runTest((Test)BoofCVTransformerTest.suite());
    }
}

