/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.jai.flattener.AbstractJAIFlattener;
import adams.data.jai.flattener.Pixels;
import adams.data.jai.transformer.AbstractJAITransformer;
import adams.data.jai.transformer.Resize;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.JAIFlattener;
import adams.flow.transformer.JAIReader;
import adams.flow.transformer.JAITransformer;
import adams.flow.transformer.WekaInstanceDumper;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class JAIFlattenerTest
extends AbstractFlowTest {
    public JAIFlattenerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("adams_logo.png");
        this.m_TestHelper.copyResourceToTmp("adams_icon.png");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("adams_logo.png");
        this.m_TestHelper.deleteFileFromTmp("adams_icon.png");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier mfs = new FileSupplier();
        mfs.setFiles(new PlaceholderFile[]{new TmpFile("adams_logo.png"), new TmpFile("adams_icon.png")});
        JAIReader ir = new JAIReader();
        JAITransformer trans = new JAITransformer();
        Resize res = new Resize();
        res.setWidth(16.0);
        res.setHeight(16.0);
        trans.setTransformAlgorithm((AbstractJAITransformer)res);
        JAIFlattener ifl = new JAIFlattener();
        Pixels pix = new Pixels();
        pix.setPixelType(Pixels.PixelType.RGB_SEPARATE);
        ifl.setFlattenAlgorithm((AbstractJAIFlattener)pix);
        WekaInstanceDumper id = new WekaInstanceDumper();
        id.setOutputPrefix((PlaceholderFile)new TmpFile("dumpfile"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{mfs, ir, trans, ifl, id});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.arff"));
    }

    public static Test suite() {
        return new TestSuite(JAIFlattenerTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        JAIFlattenerTest.runTest((Test)JAIFlattenerTest.suite());
    }
}

