/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.transformer;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;
import java.awt.image.BufferedImage;

@MixedCopyright(author="Peter Abeles", license=License.APACHE2, url="http://boofcv.org/index.php?title=Tutorial_Binary_Image", note="Example code taken from this URL")
public class Binary
extends AbstractBoofCVTransformer {
    private static final long serialVersionUID = -465068613851000709L;
    protected boolean m_UseMeanThreshold;
    protected float m_Threshold;
    protected boolean m_RemoveSmallBlobs;

    public String globalInfo() {
        return "Creates a binary image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-mean-threshold", "useMeanThreshold", (Object)false);
        this.m_OptionManager.add("threshold", "threshold", (Object)Float.valueOf(0.0f));
        this.m_OptionManager.add("remove-small-blobs", "removeSmallBlobs", (Object)false);
    }

    public void setUseMeanThreshold(boolean value) {
        this.m_UseMeanThreshold = value;
        this.reset();
    }

    public boolean getUseMeanThreshold() {
        return this.m_UseMeanThreshold;
    }

    public String useMeanThresholdTipText() {
        return "If enabled, the mean is used rather than the fixed threshold value.";
    }

    public void setThreshold(float value) {
        this.m_Threshold = value;
        this.reset();
    }

    public float getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The threshold to use.";
    }

    public void setRemoveSmallBlobs(boolean value) {
        this.m_RemoveSmallBlobs = value;
        this.reset();
    }

    public boolean getRemoveSmallBlobs() {
        return this.m_RemoveSmallBlobs;
    }

    public String removeSmallBlobsTipText() {
        return "If enabled, small blobs are removed using erode8/dilate8.";
    }

    protected BoofCVImageContainer[] doTransform(BoofCVImageContainer img) {
        ImageUInt8 filtered;
        double threshold;
        ImageFloat32 input = (ImageFloat32)ConvertBufferedImage.convertFromSingle((BufferedImage)img.toBufferedImage(), null, ImageFloat32.class);
        ImageUInt8 binary = new ImageUInt8(input.width, input.height);
        if (this.m_UseMeanThreshold) {
            threshold = ImageStatistics.mean((ImageFloat32)input);
            this.getLogger().info("mean: " + threshold);
        } else {
            threshold = this.m_Threshold;
        }
        ThresholdImageOps.threshold((ImageFloat32)input, (ImageUInt8)binary, (float)((float)threshold), (boolean)true);
        if (this.m_RemoveSmallBlobs) {
            filtered = BinaryImageOps.erode8((ImageUInt8)binary, null);
            filtered = BinaryImageOps.dilate8((ImageUInt8)filtered, null);
        } else {
            filtered = binary;
        }
        BoofCVImageContainer[] result = new BoofCVImageContainer[]{(BoofCVImageContainer)img.getHeader()};
        result[0].setImage(filtered);
        return result;
    }
}

