/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;

public class Brightness
extends AbstractJAITransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected float m_Factor;

    public String globalInfo() {
        return "Brightens or darkens an image using the specified factor.\n<0: darken image, >0: brighten image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("factor", "factor", (Object)Float.valueOf(1.0f), (Number)Float.valueOf(1.0E-4f), null);
    }

    public void setFactor(float value) {
        if ((double)value > 0.0) {
            this.m_Factor = value;
            this.reset();
        } else {
            this.getLogger().severe("Factor has to be >0, provided: " + value);
        }
    }

    public float getFactor() {
        return this.m_Factor;
    }

    public String factorTipText() {
        return "The factor to use for brightening/darkening.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImage image = img.toBufferedImage();
        RescaleOp op = new RescaleOp(this.m_Factor, 0.0f, null);
        BufferedImage filtered = op.filter(image, null);
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        result[0].setImage((Object)filtered);
        return result;
    }
}

