/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import java.awt.image.BufferedImage;

public class Crop
extends AbstractJAITransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected double m_X;
    protected double m_Y;
    protected double m_Width;
    protected double m_Height;
    protected Anchor m_Anchor;

    public String globalInfo() {
        return "Crops the image to specified width and height. Where the crop rectangle starts is defined by the X and Y position and the anchor.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)0.0, (Number)0.0, null);
        this.m_OptionManager.add("y", "Y", (Object)0.0, (Number)0.0, null);
        this.m_OptionManager.add("width", "width", (Object)1.0, (Number)1.0E-5, null);
        this.m_OptionManager.add("height", "height", (Object)1.0, (Number)1.0E-5, null);
        this.m_OptionManager.add("anchor", "anchor", (Object)Anchor.TOP_LEFT);
    }

    public void setX(double value) {
        if (value >= 0.0) {
            this.m_X = value;
            this.reset();
        } else {
            this.getLogger().severe("X has to be >=0, provided: " + value);
        }
    }

    public double getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The horizontal pixel position (0-1: percent; >1: pixels).";
    }

    public void setY(double value) {
        if (value >= 0.0) {
            this.m_Y = value;
            this.reset();
        } else {
            this.getLogger().severe("Y has to be >=0, provided: " + value);
        }
    }

    public double getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The vertical pixel position (0-1: percent; >1: pixels).";
    }

    public void setWidth(double value) {
        if (value > 0.0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getLogger().severe("Width has to be >0, provided: " + value);
        }
    }

    public double getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the crop rectangle (0-1: percent; >1: pixels).";
    }

    public void setHeight(double value) {
        if (value > 0.0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getLogger().severe("Height has to be >0, provided: " + value);
        }
    }

    public double getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the crop rectangle (0-1: percent; >1: pixels).";
    }

    public void setAnchor(Anchor value) {
        this.m_Anchor = value;
        this.reset();
    }

    public Anchor getAnchor() {
        return this.m_Anchor;
    }

    public String anchorTipText() {
        return "Defines where to anchor the position on the crop rectangle.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        int topOrig;
        int leftOrig;
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        int width = this.m_Width <= 1.0 ? (int)Math.round((double)img.getWidth() * this.m_Width) : (int)this.m_Width;
        int height = this.m_Height <= 1.0 ? (int)Math.round((double)img.getHeight() * this.m_Height) : (int)this.m_Height;
        int x = this.m_X <= 1.0 ? (int)Math.round((double)img.getWidth() * this.m_X) : (int)this.m_X;
        int y = this.m_Y <= 1.0 ? (int)Math.round((double)img.getHeight() * this.m_Y) : (int)this.m_Y;
        BufferedImage image = new BufferedImage(width, height, 2);
        switch (this.m_Anchor) {
            case TOP_LEFT: {
                leftOrig = x - 1;
                topOrig = y - 1;
                break;
            }
            case TOP_RIGHT: {
                leftOrig = x - 1 - width;
                topOrig = y - 1;
                break;
            }
            case BOTTOM_LEFT: {
                leftOrig = x - 1;
                topOrig = y - 1 - height;
                break;
            }
            case BOTTOM_RIGHT: {
                leftOrig = x - 1 - width;
                topOrig = y - 1 - height;
                break;
            }
            case CENTER: {
                leftOrig = x - 1 - width / 2;
                topOrig = y - 1 - height / 2;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled anchor: " + (Object)((Object)this.m_Anchor));
            }
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("x=" + (x - 1) + ", y=" + (y - 1) + ", width=" + width + ", height=" + height + ", anchor=" + (Object)((Object)this.m_Anchor));
            this.getLogger().info("  --> leftOrig=" + leftOrig + ", topOrig=" + topOrig);
        }
        int heightOrig = img.getHeight();
        int widthOrig = img.getWidth();
        for (y = 0; y < height; ++y) {
            int yOrig = topOrig + y;
            if (yOrig < 0 || yOrig >= heightOrig) continue;
            for (x = 0; x < width; ++x) {
                int xOrig = leftOrig + x;
                if (xOrig < 0 || xOrig >= widthOrig) continue;
                image.setRGB(x, y, ((BufferedImage)img.getImage()).getRGB(xOrig, yOrig));
            }
        }
        result[0].setImage((Object)image);
        return result;
    }

    public static enum Anchor {
        TOP_LEFT,
        TOP_RIGHT,
        CENTER,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

