/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.imagefilter.AbstractImageFilterProvider;
import adams.data.imagefilter.GrayFilterProvider;
import adams.data.jai.transformer.AbstractJAITransformer;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;

public class ImageFilter
extends AbstractJAITransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected AbstractImageFilterProvider m_Filter;
    protected boolean m_Copy;

    public String globalInfo() {
        return "Applies an ImageFilter to the buffered image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new GrayFilterProvider());
        this.m_OptionManager.add("copy", "copy", (Object)false);
    }

    public void setFilter(AbstractImageFilterProvider value) {
        this.m_Filter = value;
        this.reset();
    }

    public AbstractImageFilterProvider getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The provider of the image filter to apply to the image.";
    }

    public void setCopy(boolean value) {
        this.m_Copy = value;
        this.reset();
    }

    public boolean getCopy() {
        return this.m_Copy;
    }

    public String copyTipText() {
        return "If enabled, a copy of the image is created first before applying the filter.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)((Object)this.m_Filter), (String)"filter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"copy", (boolean)this.m_Copy, (String)"copy", (String)", ");
        return result;
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImage im = img.toBufferedImage();
        if (this.m_Copy) {
            im = BufferedImageHelper.deepCopy((BufferedImage)im);
        }
        java.awt.image.ImageFilter filter = this.m_Filter.generate(im);
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        BufferedImageContainer result = (BufferedImageContainer)img.getHeader();
        result.setImage((Object)AbstractImageFilterProvider.imageToBufferedImage(Toolkit.getDefaultToolkit().createImage(ip), 2));
        return new BufferedImageContainer[]{result};
    }
}

