/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.jai.transformer.AbstractJAITransformer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ColorQuantizerDescriptor;
import javax.media.jai.operator.ColorQuantizerType;

public class IndexedColors
extends AbstractJAITransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected int m_NumColors;
    protected ColorQuantizer m_ColorQuantizer;

    public String globalInfo() {
        return "Turns an RGB image into one with an indexed color palette.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-colors", "numColors", (Object)256, (Number)1, null);
        this.m_OptionManager.add("color-quantizer", "colorQuantizer", (Object)ColorQuantizer.MEDIANCUT);
    }

    public void setNumColors(int value) {
        if (value > 0) {
            this.m_NumColors = value;
            this.reset();
        } else {
            this.getLogger().severe("Number of colors must be >0, provided: " + value);
        }
    }

    public int getNumColors() {
        return this.m_NumColors;
    }

    public String numColorsTipText() {
        return "The maximum number of colors in the palette.";
    }

    public void setColorQuantizer(ColorQuantizer value) {
        this.m_ColorQuantizer = value;
        this.reset();
    }

    public ColorQuantizer getColorQuantizer() {
        return this.m_ColorQuantizer;
    }

    public String colorQuantizerTipText() {
        return "The type of color quantizer to use.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        RenderedOp renderedOp = ColorQuantizerDescriptor.create((RenderedImage)image, (ColorQuantizerType)ColorQuantizerDescriptor.MEDIANCUT, (Integer)this.m_NumColors, null, null, null, null, null);
        result[0] = (BufferedImageContainer)img.getHeader();
        result[0].setImage((Object)renderedOp.getRendering().getAsBufferedImage());
        return result;
    }

    public static enum ColorQuantizer {
        MEDIANCUT,
        NEUQUANT,
        OCTTREE;

    }
}

