/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.flattener;

import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.flattener.AbstractImageJFlattener;
import weka.core.Instance;
import weka.core.Instances;

public class NamedSetup
extends AbstractImageJFlattener {
    private static final long serialVersionUID = -3442872825798982018L;
    protected adams.core.NamedSetup m_Setup;
    protected AbstractImageJFlattener m_ActualScheme;

    public String globalInfo() {
        return "Applies an ImageJ flattener that is referenced via its global setup name (see 'NamedSetups').";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("setup", "setup", (Object)new adams.core.NamedSetup());
    }

    @Override
    public void reset() {
        super.reset();
        this.m_ActualScheme = null;
    }

    public void setSetup(adams.core.NamedSetup value) {
        this.m_Setup = value;
        if (!this.m_Setup.isDummy() && !this.m_Setup.exists()) {
            this.getLogger().severe("Warning: named setup '" + this.m_Setup + "' unknown!");
        }
        this.reset();
    }

    public adams.core.NamedSetup getSetup() {
        return this.m_Setup;
    }

    public String setupTipText() {
        return "The name of the setup to use.";
    }

    protected AbstractImageJFlattener getActualScheme() {
        if (this.m_ActualScheme == null) {
            this.m_ActualScheme = (AbstractImageJFlattener)this.m_Setup.getSetup();
            if (this.m_ActualScheme == null) {
                throw new IllegalStateException("Failed to instantiate named setup '" + this.m_Setup + "'!");
            }
        }
        return this.m_ActualScheme;
    }

    @Override
    public Instances createHeader(ImagePlusContainer img) {
        return this.getActualScheme().createHeader(img);
    }

    @Override
    public Instance[] doFlatten(ImagePlusContainer img) {
        return this.getActualScheme().flatten(img);
    }
}

