/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer.whitebalance;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.image.BufferedImageHelper;
import adams.data.jai.transformer.whitebalance.AbstractWhiteBalanceAlgorithm;
import java.awt.image.BufferedImage;

public class WhitePatch
extends AbstractWhiteBalanceAlgorithm
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -867061196522097584L;

    public String globalInfo() {
        return "Basic algorithm that is based on the Retinex theory of visual color constancy, which argues that perceived white is associated with the maximum cone signals. This is known as the white world assumption.\n\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INBOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Edmund Y. Lam and George S. K. Fung");
        result.setValue(TechnicalInformation.Field.CHAPTER, "10: Automatic White Balancing in Digital Photography");
        result.setValue(TechnicalInformation.Field.TITLE, "Single-Sensor Imaging: Methods and Applications for Digital Cameras");
        result.setValue(TechnicalInformation.Field.PAGES, "267-294");
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Taylor & Francis Group LLC");
        result.setValue(TechnicalInformation.Field.PDF, "http://courses.cs.washington.edu/courses/cse467/08au/labs/l5/whiteBalance.pdf");
        return result;
    }

    @Override
    protected BufferedImage doBalance(BufferedImage img) {
        img = BufferedImageHelper.convert((BufferedImage)img, (int)6);
        int width = img.getWidth();
        int height = img.getHeight();
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int[][] pixels = BufferedImageHelper.getRGBPixels((BufferedImage)img);
        for (int i = 0; i < pixels.length; ++i) {
            r = Math.max((double)pixels[i][0], r);
            g = Math.max((double)pixels[i][1], g);
            b = Math.max((double)pixels[i][2], b);
        }
        double alpha = g / r;
        double beta = g / b;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int[] split = BufferedImageHelper.split((int)img.getRGB(x, y));
                split[0] = (int)((double)split[0] * alpha);
                split[2] = (int)((double)split[2] * beta);
                img.setRGB(x, y, BufferedImageHelper.combine((int[])split));
            }
        }
        return img;
    }
}

