/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.draw;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImage;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.transformer.draw.AbstractDrawOperation;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class Image
extends AbstractDrawOperation {
    private static final long serialVersionUID = -1242368406478391978L;
    protected int m_X;
    protected int m_Y;
    protected CallableActorReference m_ImageActor;

    public String globalInfo() {
        return "Draws the image obtained from a callable actor at the specified location.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)1, (Number)1, null);
        this.m_OptionManager.add("y", "Y", (Object)1, (Number)1, null);
        this.m_OptionManager.add("image-actor", "imageActor", (Object)new CallableActorReference());
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"X", (Object)this.m_X, (String)"X: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"Y", (Object)this.m_Y, (String)", Y: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"imageActor", (Object)this.m_ImageActor, (String)", Image: ");
        return result;
    }

    public void setX(int value) {
        if (value > 0) {
            this.m_X = value;
            this.reset();
        } else {
            this.getLogger().severe("X must be >0, provided: " + value);
        }
    }

    public int getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The X position of the top-left corner of the image (1-based).";
    }

    public void setY(int value) {
        if (value > 0) {
            this.m_Y = value;
            this.reset();
        } else {
            this.getLogger().severe("Y must be >0, provided: " + value);
        }
    }

    public int getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The Y position of the top-left corner of the image (1-based).";
    }

    public void setImageActor(CallableActorReference value) {
        this.m_ImageActor = value;
        this.reset();
    }

    public CallableActorReference getImageActor() {
        return this.m_ImageActor;
    }

    public String imageActorTipText() {
        return "The callable actor to use for obtaining the image from.";
    }

    @Override
    protected String doDraw(BufferedImage image) {
        String result = null;
        if (this.m_X > image.getWidth()) {
            result = "X is larger than image width: " + this.m_X + " > " + image.getWidth();
        } else if (this.m_Y > image.getHeight()) {
            result = "Y is larger than image height: " + this.m_Y + " > " + image.getHeight();
        }
        Object obj = CallableActorHelper.getSetupFromSource(Object.class, (CallableActorReference)this.m_ImageActor, (AbstractActor)this.m_Owner);
        BufferedImage todraw = null;
        if (obj instanceof BufferedImage) {
            todraw = (BufferedImage)obj;
        } else if (obj instanceof AbstractImage) {
            todraw = ((AbstractImage)obj).toBufferedImage();
        } else {
            result = "Unknown image class: " + obj.getClass().getName();
        }
        if (result == null && todraw != null) {
            Graphics g = image.getGraphics();
            g.drawImage(todraw, this.m_X, this.m_Y, null);
        }
        return result;
    }
}

