/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.features;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.data.image.AbstractImageContainer;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.features.AbstractImageJFeatureGenerator;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;

public abstract class AbstractImageJFeatureGeneratorTestCase
extends AdamsTestCase {
    public AbstractImageJFeatureGeneratorTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/imagej/features/data");
    }

    protected ImagePlusContainer load(String filename) {
        String fullName = this.m_TestHelper.getTmpDirectory() + File.separator + filename;
        this.m_TestHelper.copyResourceToTmp(filename);
        ImagePlus img = IJ.openImage((String)fullName);
        ImagePlusContainer result = new ImagePlusContainer();
        result.setImage((Object)img);
        result.getReport().setStringValue("Filename", fullName);
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected Object[] process(ImagePlusContainer img, AbstractImageJFeatureGenerator scheme) {
        return scheme.generate((AbstractImageContainer)img);
    }

    protected String toString(Object obj) {
        if (obj instanceof Row) {
            Row row = (Row)obj;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < row.getCellCount(); ++i) {
                Cell cell;
                if (i > 0) {
                    result.append(",");
                }
                if ((cell = row.getCell(i)).isNumeric()) {
                    result.append(Utils.doubleToString((double)cell.toDouble(), (int)6));
                    continue;
                }
                result.append(cell.getContent());
            }
            return result.toString();
        }
        return obj.toString();
    }

    protected boolean save(Object[] data, String filename) {
        boolean result = true;
        for (Object obj : data) {
            result = FileUtils.writeToFile((String)(this.m_TestHelper.getTmpDirectory() + File.separator + filename), (Object)this.toString(obj), (boolean)false);
            if (!result) break;
        }
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractImageJFeatureGenerator[] getRegressionSetups();

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
        }
        result = result + ".txt";
        return result;
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractImageJFeatureGenerator[] setups = this.getRegressionSetups();
        AbstractImageJFeatureGeneratorTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            ImagePlusContainer data = this.load(input[i]);
            AbstractImageJFeatureGeneratorTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            Object[] processed = this.process(data, setups[i]);
            AbstractImageJFeatureGeneratorTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractImageJFeatureGeneratorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractImageJFeatureGeneratorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
    }
}

