/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.image.features.Pixels;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.jai.transformer.Resize;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.BufferedImageFeatureGenerator;
import adams.flow.transformer.BufferedImageTransformer;
import adams.flow.transformer.JAIReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BufferedImageFeatureGeneratorTest
extends AbstractFlowTest {
    public BufferedImageFeatureGeneratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("adams_logo.png");
        this.m_TestHelper.copyResourceToTmp("adams_icon.png");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("adams_logo.png");
        this.m_TestHelper.deleteFileFromTmp("adams_icon.png");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier mfs = new FileSupplier();
        mfs.setFiles(new PlaceholderFile[]{new TmpFile("adams_logo.png"), new TmpFile("adams_icon.png")});
        JAIReader ir = new JAIReader();
        BufferedImageTransformer trans = new BufferedImageTransformer();
        Resize res = new Resize();
        res.setWidth(16.0);
        res.setHeight(16.0);
        trans.setTransformAlgorithm((AbstractBufferedImageTransformer)res);
        BufferedImageFeatureGenerator ifl = new BufferedImageFeatureGenerator();
        Pixels pix = new Pixels();
        pix.setPixelType(Pixels.PixelType.RGB_SEPARATE);
        ifl.setAlgorithm((AbstractBufferedImageFeatureGenerator)pix);
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.csv"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{mfs, ir, trans, ifl, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.csv"));
    }

    public static Test suite() {
        return new TestSuite(BufferedImageFeatureGeneratorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BufferedImageFeatureGeneratorTest.runTest((Test)BufferedImageFeatureGeneratorTest.suite());
    }
}

