/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.image.ImageAnchor;
import adams.data.image.ImageAnchorHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class ChangeCanvasSize
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 7548064590836834398L;
    protected int m_CanvasWidth;
    protected int m_CanvasHeight;
    protected ImageAnchor m_Anchor;
    protected Color m_Background;

    public String globalInfo() {
        return "Places the image on a canvas of specified size based on the anchor.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("canvas-width", "canvasWidth", (Object)100, (Number)1, null);
        this.m_OptionManager.add("canvas-height", "canvasHeight", (Object)100, (Number)1, null);
        this.m_OptionManager.add("anchor", "anchor", (Object)ImageAnchor.TOP_LEFT);
        this.m_OptionManager.add("background", "background", (Object)Color.WHITE);
    }

    public void setCanvasWidth(int value) {
        if (value > 0) {
            this.m_CanvasWidth = value;
            this.reset();
        } else {
            this.getLogger().severe("Canvas width has to be >0, provided: " + value);
        }
    }

    public int getCanvasWidth() {
        return this.m_CanvasWidth;
    }

    public String canvasWidthTipText() {
        return "The width of the canvas in pixels.";
    }

    public void setCanvasHeight(int value) {
        if (value > 0) {
            this.m_CanvasHeight = value;
            this.reset();
        } else {
            this.getLogger().severe("Canvas height has to be >0, provided: " + value);
        }
    }

    public int getCanvasHeight() {
        return this.m_CanvasHeight;
    }

    public String canvasHeightTipText() {
        return "The height of the canvas in pixels.";
    }

    public void setAnchor(ImageAnchor value) {
        this.m_Anchor = value;
        this.reset();
    }

    public ImageAnchor getAnchor() {
        return this.m_Anchor;
    }

    public String anchorTipText() {
        return "Defines where to anchor the position on the canvas.";
    }

    public void setBackground(Color value) {
        this.m_Background = value;
        this.reset();
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public String backgroundTipText() {
        return "The background color to use.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer[] result = new BufferedImageContainer[]{new BufferedImageContainer()};
        Point[] corners = ImageAnchorHelper.calculateCorners(this.m_CanvasWidth, this.m_CanvasHeight, this.m_Anchor, 0.0, 0.0, ((BufferedImage)img.getImage()).getWidth(), ((BufferedImage)img.getImage()).getHeight());
        int leftNew = (int)corners[0].getX();
        int topNew = (int)corners[0].getY();
        int heightOrig = ((BufferedImage)img.getImage()).getHeight();
        int widthOrig = ((BufferedImage)img.getImage()).getWidth();
        BufferedImage flat = new BufferedImage(this.m_CanvasWidth, this.m_CanvasHeight, 2);
        Graphics2D g = flat.createGraphics();
        g.setColor(this.m_Background);
        g.fillRect(0, 0, this.m_CanvasWidth, this.m_CanvasHeight);
        g.dispose();
        for (int y = 0; y < heightOrig; ++y) {
            int yNew = topNew + y;
            if (yNew < 0 || yNew >= this.m_CanvasHeight) continue;
            for (int x = 0; x < widthOrig; ++x) {
                int xNew = leftNew + x;
                if (xNew < 0 || xNew >= this.m_CanvasWidth) continue;
                flat.setRGB(xNew, yNew, ((BufferedImage)img.getImage()).getRGB(x, y));
            }
        }
        result[0].setImage((Object)flat);
        return result;
    }
}

