/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.management.OS;
import adams.core.option.OptionHandler;
import adams.flow.sink.AbstractFileWriter;
import adams.flow.sink.ffmpeg.AbstractFFmpegPlugin;
import adams.flow.sink.ffmpeg.GenericPlugin;
import java.io.File;

public class FFmpeg
extends AbstractFileWriter {
    private static final long serialVersionUID = -7106585852803101639L;
    protected PlaceholderFile m_Executable;
    protected AbstractFFmpegPlugin m_Plugin;
    protected PlaceholderFile m_OutputFile;

    public String globalInfo() {
        return "Uses the specified plugin to perform an avconv/ffmpeg operation.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("executable", "executable", (Object)this.getDefaultExecutable());
        this.m_OptionManager.add("plugin", "plugin", (Object)new GenericPlugin());
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"executable", (Object)this.m_Executable, (String)", executable: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"plugin", (Object)((Object)this.m_Plugin), (String)", plugin: ");
        return result;
    }

    protected PlaceholderFile getDefaultExecutable() {
        if (OS.isWindows()) {
            return new PlaceholderFile("avconv.exe");
        }
        return new PlaceholderFile("/usr/bin/avconv");
    }

    public void setExecutable(PlaceholderFile value) {
        this.m_Executable = value;
        this.reset();
    }

    public PlaceholderFile getExecutable() {
        return this.m_Executable;
    }

    public String executableTipText() {
        return "The avconv/ffmpeg executable.";
    }

    public void setPlugin(AbstractFFmpegPlugin value) {
        this.m_Plugin = value;
        this.m_Plugin.setOwner(this);
        this.reset();
    }

    public AbstractFFmpegPlugin getPlugin() {
        return this.m_Plugin;
    }

    public String pluginTipText() {
        return "The plugin to use.";
    }

    public String outputFileTipText() {
        return "The output file to generate.";
    }

    public Class[] accepts() {
        return new Class[]{File.class, String.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (this.m_Executable.isDirectory()) {
                result = "Executable points to a directory: " + this.m_Executable;
            } else if (!this.m_Executable.exists()) {
                result = "Executable does not exist: " + this.m_Executable;
            }
        }
        if (result == null) {
            result = this.m_Plugin.setUp();
        }
        return result;
    }

    protected String doExecute() {
        if (this.m_InputToken.getPayload() instanceof File) {
            this.m_Plugin.setInput(new PlaceholderFile((File)this.m_InputToken.getPayload()));
        } else {
            this.m_Plugin.setInput(new PlaceholderFile((String)this.m_InputToken.getPayload()));
        }
        return this.m_Plugin.execute();
    }
}

