/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.CleanUpHandler;
import adams.core.Utils;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.io.input.AbstractImageReader;
import adams.flow.control.SubProcess;
import adams.flow.core.AbstractActor;
import adams.flow.core.Compatibility;
import adams.flow.core.Token;
import adams.flow.transformer.locateobjects.AbstractObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.locateobjects.PassThrough;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.CustomPopupMenuProvider;
import adams.gui.core.GUIHelper;
import adams.gui.core.Undo;
import adams.gui.flow.FlowPanel;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ImageProcessorSubPanel
extends BasePanel
implements CleanUpHandler {
    private static final long serialVersionUID = -5617124372054881553L;
    protected LayoutType m_LayoutType;
    protected ImagePanel m_PanelOriginal;
    protected ImagePanel m_PanelProcessed;
    protected FlowPanel m_PanelFlow;
    protected JButton m_ButtonCheck;
    protected JButton m_ButtonRun;
    protected BaseSplitPane m_SplitImagesFlow;
    protected BaseSplitPane m_SplitImages;
    protected AbstractObjectLocator m_LastObjectLocator;

    public ImageProcessorSubPanel() {
        this(LayoutType.VERTICAL);
    }

    public ImageProcessorSubPanel(LayoutType layout) {
        this.setLayoutType(layout);
    }

    protected void initialize() {
        super.initialize();
        this.m_LayoutType = LayoutType.VERTICAL;
        this.m_LastObjectLocator = new PassThrough();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitImagesFlow = new BaseSplitPane(1);
        this.m_SplitImagesFlow.setResizeWeight(1.0);
        this.add((Component)this.m_SplitImagesFlow, "Center");
        this.m_PanelFlow = new FlowPanel();
        this.m_PanelFlow.getTitleGenerator().setEnabled(false);
        this.m_PanelFlow.setMinimumSize(new Dimension(250, 0));
        this.m_PanelFlow.getUndo().clear();
        this.m_PanelFlow.setCurrentFlow((AbstractActor)new SubProcess());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_PanelFlow, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panel.add((Component)panelButtons, "South");
        this.m_ButtonCheck = new JButton("Check", GUIHelper.getIcon((String)"validate.png"));
        this.m_ButtonCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageProcessorSubPanel.this.checkFlow(false);
            }
        });
        panelButtons.add(this.m_ButtonCheck);
        this.m_ButtonRun = new JButton("Run", GUIHelper.getIcon((String)"run.gif"));
        this.m_ButtonRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageProcessorSubPanel.this.runFlow();
            }
        });
        panelButtons.add(this.m_ButtonRun);
        this.m_SplitImages = new BaseSplitPane(0);
        this.m_SplitImages.setResizeWeight(0.5);
        this.m_SplitImagesFlow.setLeftComponent((Component)this.m_SplitImages);
        this.m_SplitImagesFlow.setRightComponent((Component)panel);
        this.m_PanelOriginal = new ImagePanel();
        this.m_PanelOriginal.setShowProperties(false);
        this.m_PanelOriginal.setShowLog(false);
        ImagePopupMenuProvider popup = new ImagePopupMenuProvider(this.m_PanelOriginal);
        this.m_PanelOriginal.setCustomPopupMenuProvider((CustomPopupMenuProvider)popup);
        this.m_PanelProcessed = new ImagePanel();
        this.m_PanelProcessed.setShowProperties(false);
        this.m_PanelProcessed.setShowLog(false);
        popup = new ImagePopupMenuProvider(this.m_PanelProcessed);
        this.m_PanelProcessed.setCustomPopupMenuProvider((CustomPopupMenuProvider)popup);
        this.m_SplitImages.setTopComponent((Component)this.m_PanelOriginal);
        this.m_SplitImages.setBottomComponent((Component)this.m_PanelProcessed);
    }

    protected void updateLayout() {
        switch (this.m_LayoutType) {
            case HORIZONTAL: {
                this.m_SplitImages.setOrientation(1);
                break;
            }
            case VERTICAL: {
                this.m_SplitImages.setOrientation(0);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled layout type: " + (Object)((Object)this.m_LayoutType));
            }
        }
    }

    public void setLayoutType(LayoutType value) {
        this.m_LayoutType = value;
        this.updateLayout();
    }

    public LayoutType getLayoutType() {
        return this.m_LayoutType;
    }

    public ImagePanel getOriginal() {
        return this.m_PanelOriginal;
    }

    public ImagePanel getProcessed() {
        return this.m_PanelProcessed;
    }

    public FlowPanel getFlow() {
        return this.m_PanelFlow;
    }

    public boolean load(File file) {
        return this.load(file, null);
    }

    public boolean load(File file, AbstractImageReader reader) {
        boolean result = this.m_PanelOriginal.load(file, reader);
        if (result) {
            this.m_PanelProcessed.setCurrentImage(this.m_PanelOriginal.getCurrentImage());
        }
        return result;
    }

    public File getCurrentFile() {
        return this.m_PanelOriginal.getCurrentFile();
    }

    protected boolean checkFlow(boolean silent) {
        String msg = null;
        AbstractActor actor = this.m_PanelFlow.getCurrentFlow();
        SubProcess sub = null;
        if (!(actor instanceof SubProcess)) {
            msg = "Outermost actor must be a " + SubProcess.class.getName() + ", found: " + actor.getClass().getName();
        } else {
            sub = (SubProcess)actor;
        }
        if (msg == null) {
            Compatibility comp = new Compatibility();
            if (!comp.isCompatible(new Class[]{AbstractImageContainer.class}, sub.accepts())) {
                msg = "Flow snippet does not accept " + AbstractImageContainer.class.getClass() + ", found: " + Utils.classesToString((Class[])sub.accepts());
            } else if (!comp.isCompatible(sub.generates(), new Class[]{AbstractImageContainer.class})) {
                msg = "Flow snippet does not generate " + AbstractImageContainer.class.getClass() + ", found: " + Utils.classesToString((Class[])sub.generates());
            }
        }
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Flow failed test:\n" + msg));
        } else if (!silent) {
            GUIHelper.showInformationMessage((Component)((Object)this), (String)"Flow passed test!");
        }
        return msg == null;
    }

    protected void runFlow() {
        if (!this.checkFlow(true)) {
            return;
        }
        BufferedImageContainer contIn = new BufferedImageContainer();
        contIn.setImage((Object)this.m_PanelOriginal.getCurrentImage());
        AbstractImageContainer contOut = null;
        SubProcess sub = (SubProcess)this.m_PanelFlow.getCurrentFlow();
        String msg = sub.setUp();
        if (msg == null) {
            sub.input(new Token((Object)contIn));
            msg = sub.execute();
        }
        if (msg == null) {
            if (sub.hasPendingOutput()) {
                contOut = (AbstractImageContainer)sub.output().getPayload();
            } else {
                msg = "No output produced?";
            }
        }
        sub.cleanUp();
        sub.destroy();
        if (contOut != null) {
            this.m_PanelProcessed.setCurrentImage(contOut.toBufferedImage());
            this.m_PanelProcessed.setScale(-1.0);
        } else if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Flow execution failed:\n" + msg));
        }
    }

    public Undo getUndo() {
        return this.getFlow().getUndo();
    }

    public boolean isUndoSupported() {
        return this.getFlow().isUndoSupported();
    }

    public void undo() {
        this.getFlow().undo();
    }

    public void redo() {
        this.getFlow().redo();
    }

    public void clearImageOverlays(boolean original) {
        if (original) {
            this.m_PanelOriginal.clearImageOverlays();
        } else {
            this.m_PanelProcessed.clearImageOverlays();
        }
    }

    public Iterator<ImageOverlay> imageOverlays(boolean original) {
        if (original) {
            return this.m_PanelOriginal.imageOverlays();
        }
        return this.m_PanelProcessed.imageOverlays();
    }

    public void locateObjects(boolean original) {
        GenericObjectEditorDialog dialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
        dialog.setTitle("Locate objects");
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.getGOEEditor().setClassType(AbstractObjectLocator.class);
        dialog.setCurrent((Object)this.m_LastObjectLocator);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        this.clearImageOverlays(original);
        this.m_LastObjectLocator = (AbstractObjectLocator)((Object)dialog.getCurrent());
        ObjectLocationsOverlayFromReport overlay = new ObjectLocationsOverlayFromReport();
        if (original) {
            this.m_PanelOriginal.addImageOverlay((ImageOverlay)overlay);
            LocatedObjects located = this.m_LastObjectLocator.locate(this.m_PanelOriginal.getCurrentImage());
            this.m_PanelOriginal.setAdditionalProperties(located.toReport(overlay.getPrefix()));
        } else {
            this.m_PanelProcessed.addImageOverlay((ImageOverlay)overlay);
            LocatedObjects located = this.m_LastObjectLocator.locate(this.m_PanelProcessed.getCurrentImage());
            this.m_PanelProcessed.setAdditionalProperties(located.toReport(overlay.getPrefix()));
        }
    }

    public void cleanUp() {
        this.m_PanelOriginal.cleanUp();
        this.m_PanelProcessed.cleanUp();
        this.m_PanelFlow.cleanUp();
    }

    public static class ImagePopupMenuProvider
    implements CustomPopupMenuProvider {
        protected ImagePanel m_Panel;

        public ImagePopupMenuProvider(ImagePanel panel) {
            if (panel == null) {
                throw new IllegalArgumentException("ImagePanel instance cannot be null!");
            }
            this.m_Panel = panel;
        }

        public ImagePanel getPanel() {
            return this.m_Panel;
        }

        public JPopupMenu getCustomPopupMenu(MouseEvent e) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon((String)"copy.gif"));
            menuitem.setEnabled(this.getPanel().getCurrentImage() != null);
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUIHelper.copyToClipboard((BufferedImage)ImagePopupMenuProvider.this.getPanel().getCurrentImage());
                }
            });
            menu.add(menuitem);
            menuitem = new JMenuItem("Export...", GUIHelper.getIcon((String)"save.gif"));
            menuitem.setEnabled(this.getPanel().getCurrentImage() != null);
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImagePopupMenuProvider.this.getPanel().export();
                }
            });
            menu.add(menuitem);
            menuitem = new JMenuItem("Save report...", GUIHelper.getEmptyIcon());
            menuitem.setEnabled(this.getPanel().getCurrentImage() != null);
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImagePopupMenuProvider.this.getPanel().saveReport();
                }
            });
            menu.add(menuitem);
            menu.addSeparator();
            JMenu submenu = new JMenu("Zoom");
            menu.add(submenu);
            submenu.setIcon(GUIHelper.getIcon((String)"glasses.gif"));
            menuitem = new JMenuItem("Zoom in");
            submenu.add(menuitem);
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImagePopupMenuProvider.this.m_Panel.setScale(ImagePopupMenuProvider.this.m_Panel.getActualScale() * 1.5);
                }
            });
            menuitem = new JMenuItem("Zoom out");
            submenu.add(menuitem);
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImagePopupMenuProvider.this.m_Panel.setScale(ImagePopupMenuProvider.this.m_Panel.getActualScale() / 1.5);
                }
            });
            int[] zooms = new int[]{-100, 25, 50, 66, 75, 100, 150, 200, 400, 800};
            submenu.addSeparator();
            for (int i = 0; i < zooms.length; ++i) {
                final int fZoom = zooms[i];
                menuitem = zooms[i] == -100 ? new JMenuItem("Best fit") : new JMenuItem(zooms[i] + "%");
                submenu.add(menuitem);
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ImagePopupMenuProvider.this.m_Panel.setScale((double)fZoom / 100.0);
                    }
                });
            }
            return menu;
        }
    }

    public static enum LayoutType {
        HORIZONTAL,
        VERTICAL;

    }
}

