/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.transformer.locateobjects.AbstractObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public abstract class AbstractObjectLocatorTestCase
extends AdamsTestCase {
    public AbstractObjectLocatorTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/flow/transformer/locateobjects/data");
    }

    protected BufferedImage load(String filename) {
        BufferedImage result = null;
        this.m_TestHelper.copyResourceToTmp(filename);
        RenderedOp op = JAI.create((String)"fileload", (Object)new TmpFile(filename).getAbsolutePath());
        if (op != null) {
            result = op.getAsBufferedImage();
        }
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractObjectLocator[] getRegressionSetups();

    protected LocatedObject[] process(BufferedImage data, AbstractObjectLocator scheme) {
        LocatedObjects result = scheme.locate(data);
        return result.toArray(new LocatedObject[result.size()]);
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    protected boolean save(LocatedObject[] data, String filename) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < data.length; ++i) {
            String line = "x=" + data[i].getX() + ", y=" + data[i].getY() + ", w=" + data[i].getWidth() + ", h=" + data[i].getHeight();
            list.add(line);
        }
        return FileUtils.saveToFile(list, (File)new TmpFile(filename));
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractObjectLocator[] setups = this.getRegressionSetups();
        AbstractObjectLocatorTestCase.assertEquals((String)"Number of input files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            BufferedImage data = this.load(input[i]);
            AbstractObjectLocatorTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            AbstractObjectLocator currSetup = (AbstractObjectLocator)OptionUtils.shallowCopy((OptionHandler)setups[i], (boolean)true);
            AbstractObjectLocatorTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)currSetup);
            LocatedObject[] processed = this.process(data, currSetup);
            AbstractObjectLocatorTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractObjectLocatorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (currSetup instanceof Destroyable) {
                currSetup.destroy();
                continue;
            }
            if (!(currSetup instanceof CleanUpHandler)) continue;
            currSetup.cleanUp();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractObjectLocatorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

