/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.base.QuadrilateralLocation;
import adams.data.conversion.AbstractConversionToString;

public class QuadrilateralLocationToString
extends AbstractConversionToString {
    private static final long serialVersionUID = 6360278226666467183L;
    protected boolean m_UseIntegers;

    public String globalInfo() {
        return "Turns a quadrilateral object into a string of the format 'A.x A.y B.x B.y C.x C.y D.x D.y'.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-integers", "useIntegers", (Object)false);
    }

    public void setUseIntegers(boolean value) {
        this.m_UseIntegers = value;
        this.reset();
    }

    public boolean getUseIntegers() {
        return this.m_UseIntegers;
    }

    public String useIntegersTipText() {
        return "If enabled, rounded integers are output instead of doubles.";
    }

    public Class accepts() {
        return QuadrilateralLocation.class;
    }

    protected Object doConvert() throws Exception {
        double[] doubles = ((QuadrilateralLocation)((Object)this.m_Input)).doubleValue();
        int[] ints = new int[doubles.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = (int)Math.round(doubles[i]);
        }
        String result = this.m_UseIntegers ? ints[0] + " " + ints[1] + " " + ints[2] + " " + ints[3] + " " + ints[4] + " " + ints[5] + " " + ints[6] + " " + ints[7] : doubles[0] + " " + doubles[1] + " " + doubles[2] + " " + doubles[3] + " " + doubles[4] + " " + doubles[5] + " " + doubles[6] + " " + doubles[7];
        return result;
    }
}

