/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import java.util.ArrayList;
import java.util.List;

public class Dimensions
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;

    public String globalInfo() {
        return "Outputs the dimensions of the image: width, height, area, ratio.";
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("Width", DataType.NUMERIC);
        result.add("Height", DataType.NUMERIC);
        result.add("Area (w*h)", DataType.NUMERIC);
        result.add("Ratio (w/h)", DataType.NUMERIC);
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        List[] result = new List[]{new ArrayList()};
        result[0].add(img.getWidth());
        result[0].add(img.getHeight());
        result[0].add(img.getWidth() * img.getHeight());
        if (img.getHeight() > 0) {
            result[0].add((double)img.getWidth() / (double)img.getHeight());
        } else {
            result[0].add(null);
        }
        return result;
    }
}

