/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.image.moments.AbstractBufferedImageMoment;
import adams.data.image.moments.MomentHelper;
import adams.data.report.DataType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class Eccentricity
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = 3584074710241497942L;
    protected Color m_BackgroundValue;

    public String globalInfo() {
        return "Computes the eccentricity of the object.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("background-value", "backgroundValue", (Object)Color.WHITE);
    }

    public void setBackgroundValue(Color value) {
        this.m_BackgroundValue = value;
        this.reset();
    }

    public Color getBackgroundValue() {
        return this.m_BackgroundValue;
    }

    public String backgroundValueTipText() {
        return "The background color.";
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("Eccentricity", DataType.NUMERIC);
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        List[] result = new List[]{new ArrayList()};
        result[0].add(MomentHelper.eccentricity((boolean[][])AbstractBufferedImageMoment.imageToMatrix(img, this.m_BackgroundValue)));
        return result;
    }
}

