/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.ImageAnchor;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.image.features.Pixels;
import adams.data.image.transformer.Cropping;
import adams.data.image.transformer.crop.RelativeCrop;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.flow.transformer.PixelSelector;
import adams.flow.transformer.pixelselector.AddClassification;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PixelClassifications
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -511904410456677378L;
    protected int m_Width;
    protected int m_Height;
    protected ImageAnchor m_Anchor;
    protected Pixels.PixelType m_PixelType;

    public String globalInfo() {
        return "Generates a feature vector for each pixel classification that is stored in the image's report.\nPixel classifications are generated with the " + PixelSelector.class.getName() + " transformer, using the " + AddClassification.class.getName() + " action.\nAutomatically adds the classification label associated with a classification position in the report as a separate attribute.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)100, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)75, (Number)1, null);
        this.m_OptionManager.add("anchor", "anchor", (Object)ImageAnchor.TOP_LEFT);
        this.m_OptionManager.add("pixel-type", "pixelType", (Object)Pixels.PixelType.RGB_SINGLE);
    }

    public void setWidth(int value) {
        if (value > 0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getLogger().severe("Width has to be >0, provided: " + value);
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the crop rectangle.";
    }

    public void setHeight(int value) {
        if (value > 0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getLogger().severe("Height has to be >0, provided: " + value);
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the crop rectangle.";
    }

    public void setAnchor(ImageAnchor value) {
        this.m_Anchor = value;
        this.reset();
    }

    public ImageAnchor getAnchor() {
        return this.m_Anchor;
    }

    public String anchorTipText() {
        return "Defines where to anchor the position on the crop rectangle.";
    }

    public void setPixelType(Pixels.PixelType value) {
        this.m_PixelType = value;
        this.reset();
    }

    public Pixels.PixelType getPixelType() {
        return this.m_PixelType;
    }

    public String pixelTypeTipText() {
        return "The pixel type to use.";
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        RelativeCrop crop = new RelativeCrop();
        crop.setWidth(this.m_Width);
        crop.setHeight(this.m_Height);
        crop.setAnchor(ImageAnchor.TOP_LEFT);
        crop.setX(1.0);
        crop.setY(1.0);
        Cropping cropping = new Cropping();
        cropping.setAlgorithm(crop);
        img = ((BufferedImageContainer[])cropping.transform((AbstractImageContainer)img))[0];
        crop.destroy();
        Pixels pixels = new Pixels();
        pixels.setPixelType(this.m_PixelType);
        HeaderDefinition result = pixels.createHeader(img);
        pixels.destroy();
        result.add("Classification", DataType.STRING);
        return result;
    }

    protected Integer[] getClassificationIndices(BufferedImageContainer img) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List fields = img.getReport().getFields();
        for (AbstractField field : fields) {
            if (!field.getName().startsWith("Classification.")) continue;
            result.add(Integer.parseInt(field.getName().substring("Classification.".length())));
        }
        return result.toArray(new Integer[result.size()]);
    }

    protected Point getPixelLocation(BufferedImageContainer img, int index) {
        Report report;
        Point result = null;
        if (img != null && img.hasReport() && (report = img.getReport()).hasValue("Pixel.X." + index) && report.hasValue("Pixel.Y." + index)) {
            result = new Point(report.getDoubleValue("Pixel.X." + index).intValue(), report.getDoubleValue("Pixel.Y." + index).intValue());
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        Integer[] indices;
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        for (Integer index : indices = this.getClassificationIndices(img)) {
            Point loc = this.getPixelLocation(img, index);
            RelativeCrop crop = new RelativeCrop();
            crop.setWidth(this.m_Width);
            crop.setHeight(this.m_Height);
            crop.setAnchor(this.m_Anchor);
            crop.setUseAnchorAtPos(true);
            crop.setX((int)(loc.getX() + 1.0));
            crop.setY((int)(loc.getY() + 1.0));
            crop.setLoggingLevel(this.getLoggingLevel());
            Cropping cropping = new Cropping();
            cropping.setAlgorithm(crop);
            BufferedImageContainer cropped = ((BufferedImageContainer[])cropping.transform((AbstractImageContainer)img))[0];
            crop.destroy();
            Pixels pixels = new Pixels();
            pixels.setPixelType(this.m_PixelType);
            pixels.setFields(new Field[]{new Field("Classification." + index, DataType.STRING)});
            List<Object>[] data = pixels.postProcessRows(img, pixels.generateRows(cropped));
            pixels.destroy();
            if (data.length == 0) continue;
            result.addAll(Arrays.asList(data));
        }
        return result.toArray(new List[result.size()]);
    }
}

