/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.awt.image.BufferedImage;

public class ImageType
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected Type m_Type;

    public String globalInfo() {
        return "Turns an image into the specified type of image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)Type.TYPE_INT_ARGB);
    }

    public void setType(Type value) {
        this.m_Type = value;
        this.reset();
    }

    public Type getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of image to convert to.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)this.m_Type.getType());
        result[0] = (BufferedImageContainer)img.getHeader();
        result[0].setImage((Object)image);
        return result;
    }

    public static enum Type {
        TYPE_3BYTE_BGR(5),
        TYPE_4BYTE_ABGR(6),
        TYPE_4BYTE_ABGR_PRE(7),
        TYPE_BYTE_BINARY(12),
        TYPE_BYTE_GRAY(10),
        TYPE_BYTE_INDEXED(13),
        TYPE_CUSTOM(0),
        TYPE_INT_ARGB(2),
        TYPE_INT_ARGB_PRE(3),
        TYPE_INT_BGR(4),
        TYPE_INT_RGB(1),
        TYPE_USHORT_555_RGB(9),
        TYPE_USHORT_565_RGB(8),
        TYPE_USHORT_GRAY(11);

        private int m_Type;

        private Type(int type) {
            this.m_Type = type;
        }

        public int getType() {
            return this.m_Type;
        }
    }
}

