/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer.whitebalance;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.Utils;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.whitebalance.AbstractWhiteBalanceAlgorithm;
import java.awt.image.BufferedImage;

public class GIMP
extends AbstractWhiteBalanceAlgorithm
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -867061196522097584L;
    protected double m_Threshold;

    public String globalInfo() {
        return "Uses the algorithm for white balancing as used by GIMP.\nThe White Balance command automatically adjusts the colors by stretching the Red, Green and Blue channels separately. To do this, it discards pixel colors at each end of the Red, Green and Blue histograms which are used by only 0.05% (default) of the pixels in the image and stretches the remaining range as much as possible. The result is that pixel colors which occur very infrequently at the outer edges of the histograms (perhaps bits of dust, etc.) do not negatively influence the minimum and maximum values used for stretching the histograms. However, there may be hue shifts in the resulting image.\n\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "GIMP");
        result.setValue(TechnicalInformation.Field.TITLE, "White Balance");
        result.setValue(TechnicalInformation.Field.NOTE, "Version 2.8");
        result.setValue(TechnicalInformation.Field.HTTP, "http://docs.gimp.org/2.8/en/gimp-layer-white-balance.html");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("threshold", "threshold", (Object)0.05, (Number)0.0, (Number)100.0);
    }

    public void setThreshold(double value) {
        if (value >= 0.0 && value <= 100.0) {
            this.m_Threshold = value;
            this.reset();
        } else {
            this.getLogger().warning("Threshold must be 0 <= x <= 100, provided: " + value);
        }
    }

    public double getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The threshold in percentage of pixels in the image below which to discard colors.";
    }

    @Override
    protected BufferedImage doBalance(BufferedImage img) {
        int n;
        int i;
        img = BufferedImageHelper.convert((BufferedImage)img, (int)6);
        int width = img.getWidth();
        int height = img.getHeight();
        int[][] histo = BufferedImageHelper.histogram((BufferedImage)img, (boolean)false);
        if (this.isLoggingEnabled()) {
            this.getLogger().finer("R: " + Utils.arrayToString((Object)histo[0]));
            this.getLogger().finer("G: " + Utils.arrayToString((Object)histo[1]));
            this.getLogger().finer("B: " + Utils.arrayToString((Object)histo[2]));
        }
        int min = (int)Math.round((double)width * (double)height * this.m_Threshold / 100.0);
        int[] first = new int[3];
        int[] last = new int[3];
        block0: for (i = 0; i < 3; ++i) {
            for (n = 0; n < histo[i].length; ++n) {
                if (histo[i][n] <= min) continue;
                first[i] = n;
                break;
            }
            for (n = histo[i].length - 1; n >= 0; --n) {
                if (histo[i][n] <= min) continue;
                last[i] = n;
                continue block0;
            }
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().finer("first: " + Utils.arrayToString((Object)first));
            this.getLogger().finer("last: " + Utils.arrayToString((Object)last));
        }
        int[][] conversion = new int[3][256];
        for (i = 0; i < 3; ++i) {
            double factor = 256.0 / (double)(last[i] - first[i] + 1);
            for (n = 0; n < 256; ++n) {
                conversion[i][n] = n < first[i] ? 0 : (n > last[i] ? 255 : (int)((double)(n - first[i]) * factor));
            }
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().finer("R (conversion): " + Utils.arrayToString((Object)conversion[0]));
            this.getLogger().finer("G (conversion): " + Utils.arrayToString((Object)conversion[1]));
            this.getLogger().finer("B (conversion): " + Utils.arrayToString((Object)conversion[2]));
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int[] split = BufferedImageHelper.split((int)img.getRGB(x, y));
                for (i = 0; i < conversion.length; ++i) {
                    split[i] = conversion[i][split[i]];
                }
                img.setRGB(x, y, BufferedImageHelper.combine((int[])split));
            }
        }
        return img;
    }
}

