/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.data.PageOrientation;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import adams.data.jai.transformer.Rotate;

public class ChangeOrientation
extends AbstractJAITransformer {
    private static final long serialVersionUID = 789668617409423108L;
    protected PageOrientation m_Orientation;
    protected double m_AnglePortraitToLandscape;
    protected double m_AngleLandscapeToPortrait;

    public String globalInfo() {
        return "Ensures that the image has the specified orientation.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("orientation", "orientation", (Object)PageOrientation.LANDSCAPE);
        this.m_OptionManager.add("angle-landscape-to-portrait", "angleLandscapeToPortrait", (Object)90.0, (Number)0.0, (Number)360.0);
        this.m_OptionManager.add("angle-portrait-to-landscape", "anglePortraitToLandscape", (Object)90.0, (Number)0.0, (Number)360.0);
    }

    public void setOrientation(PageOrientation value) {
        this.m_Orientation = value;
        this.reset();
    }

    public PageOrientation getOrientation() {
        return this.m_Orientation;
    }

    public String orientationTipText() {
        return "The page orientation to ensure.";
    }

    public void setAngleLandscapeToPortrait(double value) {
        if (this.getOptionManager().isValid("angleLandscapeToPortrait", (Number)value)) {
            this.m_AngleLandscapeToPortrait = value;
            this.reset();
        }
    }

    public double getAngleLandscapeToPortrait() {
        return this.m_AngleLandscapeToPortrait;
    }

    public String angleLandscapeToPortraitTipText() {
        return "The angle, in degrees, to rotate the image by (landscape -> portrait).";
    }

    public void setAnglePortraitToLandscape(double value) {
        if (this.getOptionManager().isValid("anglePortraitToLandscape", (Number)value)) {
            this.m_AnglePortraitToLandscape = value;
            this.reset();
        }
    }

    public double getAnglePortraitToLandscape() {
        return this.m_AnglePortraitToLandscape;
    }

    public String anglePortraitToLandscapeTipText() {
        return "The angle, in degrees, to rotate the image by (portrait -> landscape).";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer[] result;
        boolean change;
        switch (this.m_Orientation) {
            case LANDSCAPE: {
                change = img.getHeight() > img.getWidth();
                break;
            }
            case PORTRAIT: {
                change = img.getWidth() > img.getHeight();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled page orientation: " + this.m_Orientation);
            }
        }
        if (change) {
            Rotate rotate = new Rotate();
            if (this.m_Orientation == PageOrientation.LANDSCAPE) {
                rotate.setAngle(this.m_AnglePortraitToLandscape);
            } else {
                rotate.setAngle(this.m_AngleLandscapeToPortrait);
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Orientation needs to be adjusted to " + this.m_Orientation + " by " + rotate.getAngle() + " degrees");
            }
            rotate.setInterpolation(Rotate.InterpolationType.NONE);
            result = (BufferedImageContainer[])rotate.transform((AbstractImageContainer)img);
            rotate.cleanUp();
        } else {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Orientation is already " + this.m_Orientation);
            }
            result = new BufferedImageContainer[]{img};
        }
        return result;
    }
}

