/*
 * Decompiled with CFR 0.152.
 */
package adams.data.lire.features;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.data.statistics.StatUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PHOG
extends AbstractBufferedImageFeatureGenerator
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -1709055659856624762L;

    public String globalInfo() {
        return "Generates features using " + net.semanticmetadata.lire.imageanalysis.PHOG.class.getName() + ".\nFor more information, see:\n" + this.getTechnicalInformation().toString() + "\nFor more information on the LIRE project, see:\nhttp://code.google.com/p/lire/";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Anna Bosch, Andrew Zisserman & Xavier Munoz");
        result.setValue(TechnicalInformation.Field.TITLE, "Representing shape with a spatial pyramid kernel");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "CIVR 2007");
        result.setValue(TechnicalInformation.Field.YEAR, "2007");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "ACM");
        return result;
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        net.semanticmetadata.lire.imageanalysis.PHOG features = new net.semanticmetadata.lire.imageanalysis.PHOG();
        features.extract(image);
        double[] histo = features.getDoubleHistogram();
        HeaderDefinition result = new HeaderDefinition();
        for (int i = 0; i < histo.length; ++i) {
            result.add("PHOG-" + (i + 1), DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        List[] result = null;
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        net.semanticmetadata.lire.imageanalysis.PHOG features = new net.semanticmetadata.lire.imageanalysis.PHOG();
        features.extract(image);
        double[] histo = features.getDoubleHistogram();
        result = new List[]{new ArrayList()};
        result[0].addAll(Arrays.asList(StatUtils.toNumberArray((double[])histo)));
        return result;
    }
}

