/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.source.AbstractArrayProvider;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import java.awt.Color;

public class ColorProvider
extends AbstractArrayProvider {
    private static final long serialVersionUID = -3505768725369077351L;
    protected AbstractColorProvider m_Provider;
    protected int m_NumColors;

    public String globalInfo() {
        return "Uses the configured color provider to generate a number of colors.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("provider", "provider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("num-colors", "numColors", (Object)10, (Number)1, null);
    }

    public String outputArrayTipText() {
        return "If enabled, outputs the colors in an array rather than one-by-one.";
    }

    public void setProvider(AbstractColorProvider value) {
        this.m_Provider = value;
        this.reset();
    }

    public AbstractColorProvider getProvider() {
        return this.m_Provider;
    }

    public String providerTipText() {
        return "The color provider to use for generating the colors.";
    }

    public void setNumColors(int value) {
        if (value > 0) {
            this.m_NumColors = value;
            this.reset();
        } else {
            this.getLogger().severe("Must at least generate 1 color, provided: " + value);
        }
    }

    public int getNumColors() {
        return this.m_NumColors;
    }

    public String numColorsTipText() {
        return "The number of colors to generate with the color provider.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"provider", (Object)this.m_Provider);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"numColors", (Object)this.m_NumColors, (String)", # colors: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (Object)(this.m_OutputArray ? "as array" : "one by one"), (String)", ");
        return result;
    }

    protected Class getItemClass() {
        return Color.class;
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        this.m_Provider.resetColors();
        for (int i = 0; i < this.m_NumColors; ++i) {
            this.m_Queue.add(this.m_Provider.next());
        }
        return result;
    }
}

