/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.management.OS;
import adams.core.option.OptionHandler;
import adams.data.tesseract.TesseractHelper;
import adams.flow.core.TesseractLanguage;
import adams.flow.core.TesseractPageSegmentation;
import adams.flow.standalone.AbstractStandalone;

public class TesseractConfiguration
extends AbstractStandalone {
    private static final long serialVersionUID = -1959430342987913960L;
    protected PlaceholderFile m_Executable;
    protected PlaceholderFile m_ConfigFile;

    public String globalInfo() {
        return "Setup parameters for tesseract.\nFor more information see:\nhttp://code.google.com/p/tesseract-ocr/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("executable", "executable", (Object)this.getDefaultExecutable());
        this.m_OptionManager.add("config-file", "configFile", (Object)new PlaceholderFile("."));
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"executable", (Object)this.m_Executable, (String)"exe: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"config", (Object)this.m_ConfigFile, (String)", config: ");
        return result;
    }

    protected PlaceholderFile getDefaultExecutable() {
        if (TesseractHelper.getSingleton().getExecutable().length() > 0) {
            return new PlaceholderFile(TesseractHelper.getSingleton().getExecutable());
        }
        if (OS.isWindows()) {
            return new PlaceholderFile("tesseract.exe");
        }
        return new PlaceholderFile("/usr/bin/tesseract");
    }

    public void setExecutable(PlaceholderFile value) {
        this.m_Executable = value;
        this.reset();
    }

    public PlaceholderFile getExecutable() {
        return this.m_Executable;
    }

    public String executableTipText() {
        return "The tesseract executable to use.";
    }

    public void setConfigFile(PlaceholderFile value) {
        this.m_ConfigFile = value;
        this.reset();
    }

    public PlaceholderFile getConfigFile() {
        return this.m_ConfigFile;
    }

    public String configFileTipText() {
        return "The (optional) config file for tesseract; ignored if pointing to a directory.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (!this.m_Executable.exists()) {
                result = "Executable '" + this.m_Executable + "' does not exist!";
            } else if (this.m_Executable.isDirectory()) {
                result = "Executable '" + this.m_Executable + "' points to directory!";
            } else if (!this.m_ConfigFile.exists()) {
                result = "Config file '" + this.m_ConfigFile + "' does not exist!";
            }
        }
        return result;
    }

    protected String doExecute() {
        return null;
    }

    public String[] getCommand(String input, String outputbase, TesseractLanguage lang, TesseractPageSegmentation seg, boolean hocr) {
        return TesseractHelper.getSingleton().getCommand(this.m_Executable.getAbsolutePath(), input, outputbase, lang, seg, this.m_ConfigFile, hocr);
    }
}

