/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.draw;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.transformer.draw.AbstractColorStrokeDrawOperation;
import adams.gui.core.ColorHelper;
import adams.gui.core.GUIHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class Oval
extends AbstractColorStrokeDrawOperation {
    private static final long serialVersionUID = -1242368406478391978L;
    protected int m_X;
    protected int m_Y;
    protected int m_Width;
    protected int m_Height;
    protected boolean m_Fill;

    public String globalInfo() {
        return "Draws an oval with the specified color and dimensions at the given location. The oval can be filled as well.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)1, (Number)1, null);
        this.m_OptionManager.add("y", "Y", (Object)1, (Number)1, null);
        this.m_OptionManager.add("width", "width", (Object)10, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)10, (Number)1, null);
        this.m_OptionManager.add("fill", "fill", (Object)false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"X", (Object)this.m_X, (String)"X: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"Y", (Object)this.m_Y, (String)", Y: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_Width, (String)", W: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_Height, (String)", H: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"color", (Object)ColorHelper.toHex((Color)this.m_Color), (String)", Color: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"strokeThickness", (Object)Float.valueOf(this.m_StrokeThickness), (String)", Stroke: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"fill", (boolean)this.m_Fill, (String)"filled", (String)", ");
        return result;
    }

    public void setX(int value) {
        if (value > 0) {
            this.m_X = value;
            this.reset();
        } else {
            this.getLogger().severe("X must be >0, provided: " + value);
        }
    }

    public int getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The X position of the top-left corner of the oval (1-based).";
    }

    public void setY(int value) {
        if (value > 0) {
            this.m_Y = value;
            this.reset();
        } else {
            this.getLogger().severe("Y must be >0, provided: " + value);
        }
    }

    public int getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The Y position of the top-left corner of the oval (1-based).";
    }

    public void setWidth(int value) {
        if (value > 0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getLogger().severe("Width must be >0, provided: " + value);
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the oval.";
    }

    public void setHeight(int value) {
        if (value > 0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getLogger().severe("Height must be >0, provided: " + value);
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the oval.";
    }

    public void setFill(boolean value) {
        this.m_Fill = value;
        this.reset();
    }

    public boolean getFill() {
        return this.m_Fill;
    }

    public String fillTipText() {
        return "If enabled, the oval gets filled with the specified color.";
    }

    @Override
    protected String check(BufferedImage image) {
        String result = super.check(image);
        if (result == null) {
            if (this.m_X > image.getWidth()) {
                result = "X is larger than image width: " + this.m_X + " > " + image.getWidth();
            } else if (this.m_Y > image.getHeight()) {
                result = "Y is larger than image height: " + this.m_Y + " > " + image.getHeight();
            } else if (this.m_X + this.m_Width > image.getWidth()) {
                result = "X+Width is larger than image width: " + (this.m_X + this.m_Width) + " > " + image.getWidth();
            } else if (this.m_Y + this.m_Height > image.getHeight()) {
                result = "Y+Height is larger than image height: " + (this.m_Y + this.m_Height) + " > " + image.getHeight();
            }
        }
        return result;
    }

    @Override
    protected String doDraw(BufferedImage image) {
        Graphics g = image.getGraphics();
        g.setColor(this.m_Color);
        GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
        ((Graphics2D)g).setStroke(new BasicStroke(this.m_StrokeThickness));
        if (this.m_Fill) {
            g.fillOval(this.m_X, this.m_Y, this.m_Width, this.m_Height);
        } else {
            g.drawOval(this.m_X, this.m_Y, this.m_Width, this.m_Height);
        }
        return null;
    }
}

