/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.visualization.image.AbstractImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class ObjectLocationsOverlayFromReport
extends AbstractImageOverlay {
    private static final long serialVersionUID = 6356419097401574024L;
    protected String m_Prefix;
    protected Color m_Color;
    protected List<Rectangle> m_Locations;

    public String globalInfo() {
        return "Displays the locations of objects in the image, using data from the attached report.\nSuffixes:\n.x\n.y\n.width\n.height\n";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix of fields in the report to identify as object location, eg 'Object.'.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the objects.";
    }

    protected synchronized void doImageChanged(ImagePanel.PaintPanel panel) {
        this.m_Locations = null;
    }

    protected void determineLocations(Report report) {
        if (this.m_Locations != null) {
            return;
        }
        this.m_Locations = new ArrayList<Rectangle>();
        LocatedObjects located = LocatedObjects.fromReport(report, this.m_Prefix);
        for (LocatedObject object : located) {
            this.m_Locations.add(object.getRectangle());
        }
    }

    protected synchronized void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        this.determineLocations(panel.getOwner().getAdditionalProperties());
        if (this.m_Locations.size() > 0) {
            g.setColor(this.m_Color);
            for (Rectangle rect : this.m_Locations) {
                g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            }
        }
    }
}

