/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.io.FileUtils;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.Report;
import adams.gui.chooser.DefaultReportFileChooser;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.visualization.image.AbstractImageOverlay;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import adams.gui.visualization.image.plugins.AbstractImageViewerPlugin;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public class DisplayObjectLocationsFromReport
extends AbstractImageViewerPlugin {
    private static final long serialVersionUID = -7792128547228275760L;

    public String getMenu() {
        return "View";
    }

    public String getCaption() {
        return "Located objects (report)...";
    }

    public String getIconName() {
        return "locateobjects.gif";
    }

    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null;
    }

    protected String createLogEntry() {
        return null;
    }

    protected ObjectLocationsOverlayFromReport configureOverlay() {
        ObjectLocationsOverlayFromReport result = new ObjectLocationsOverlayFromReport();
        GenericObjectEditorDialog dialog = ((ImagePanel)this.m_CurrentPanel).getParentDialog() != null ? new GenericObjectEditorDialog(((ImagePanel)this.m_CurrentPanel).getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(((ImagePanel)this.m_CurrentPanel).getParentFrame(), true);
        dialog.setTitle("Configure overlay");
        dialog.setDefaultCloseOperation(2);
        dialog.getGOEEditor().setClassType(AbstractImageOverlay.class);
        dialog.getGOEEditor().setCanChangeClassInDialog(false);
        dialog.setCurrent((Object)result);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)this.m_CurrentPanel);
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return null;
        }
        result = (ObjectLocationsOverlayFromReport)((Object)dialog.getCurrent());
        return result;
    }

    protected DefaultReportFileChooser configureFileChooser(File file) {
        DefaultReportFileChooser result = new DefaultReportFileChooser();
        if (file != null) {
            result.setCurrentDirectory(file.getParentFile().getAbsoluteFile());
            file = FileUtils.replaceExtension((File)file.getAbsoluteFile(), (String)".report");
            result.setCorrectOpenFileFilter(file);
            result.setSelectedFile(file);
        }
        return result;
    }

    protected String doExecute() {
        DefaultReportFileChooser fileChooser = this.configureFileChooser(((ImagePanel)this.m_CurrentPanel).getCurrentFile());
        int retVal = fileChooser.showOpenDialog((Component)this.m_CurrentPanel);
        if (retVal != 0) {
            return null;
        }
        AbstractReportReader reader = (AbstractReportReader)fileChooser.getReader();
        reader.setInput(fileChooser.getSelectedPlaceholderFile());
        List locations = reader.read();
        if (locations.size() == 0) {
            return "Failed to read any report from: " + fileChooser.getSelectedFile();
        }
        ObjectLocationsOverlayFromReport overlay = null;
        Iterator iter = ((ImagePanel)this.m_CurrentPanel).imageOverlays();
        while (iter.hasNext()) {
            ImageOverlay io = (ImageOverlay)iter.next();
            if (!(io instanceof ObjectLocationsOverlayFromReport)) continue;
            overlay = (ObjectLocationsOverlayFromReport)io;
            break;
        }
        if (overlay == null && (overlay = this.configureOverlay()) == null) {
            return "Cancelled overlay configuration!";
        }
        ((ImagePanel)this.m_CurrentPanel).addImageOverlay((ImageOverlay)overlay);
        ((ImagePanel)this.m_CurrentPanel).setAdditionalProperties((Report)locations.get(0));
        return null;
    }
}

