/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.core.logging.LoggingSupporter;
import adams.core.management.ProcessUtils;
import adams.core.option.OptionUtils;
import adams.data.tesseract.TesseractHelper;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.TextDialog;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractImageViewerPlugin;
import java.awt.Component;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;

public class TesseractOCR
extends AbstractImageViewerPlugin {
    private static final long serialVersionUID = -3146372359577147914L;
    protected String m_LastCommand;

    public String getMenu() {
        return "Process";
    }

    public String getCaption() {
        return "Tesseract OCR";
    }

    public String getIconName() {
        return "tesseract.png";
    }

    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null;
    }

    protected String createLogEntry() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.m_LastCommand;
    }

    protected String doExecute() {
        String result = null;
        this.m_LastCommand = "";
        File tmp = null;
        try {
            tmp = TempUtils.createTempFile((String)"ocr", (String)".png");
            if (!ImageIO.write((RenderedImage)((ImagePanel)this.m_CurrentPanel).getCurrentImage(), "PNG", tmp)) {
                result = "Failed to save current image as temp file: " + tmp;
            }
        }
        catch (Exception e) {
            result = Utils.handleException((LoggingSupporter)this, (String)"Failed to save current image as temp file!", (Throwable)e);
        }
        String[] cmd = null;
        if (result == null) {
            cmd = TesseractHelper.getSingleton().getCommand(tmp.getAbsolutePath(), FileUtils.replaceExtension((String)tmp.getAbsolutePath(), (String)""), new PlaceholderFile("."));
        }
        if (cmd != null) {
            this.m_LastCommand = OptionUtils.joinOptions(cmd);
            try {
                ProcessUtils.ProcessResult proc = ProcessUtils.execute(cmd);
                if (proc.getExitCode() != 0) {
                    result = "OCR failed with exit code: " + proc.getExitCode() + "\n" + proc.getStdErr();
                }
            }
            catch (Exception e) {
                result = Utils.handleException((LoggingSupporter)this, (String)("Failed to apply OCR: " + this.m_LastCommand), (Throwable)e);
            }
        }
        List lines = null;
        File tmp2 = null;
        if (result == null && (lines = FileUtils.loadFromFile((File)(tmp2 = FileUtils.replaceExtension((File)tmp, (String)".txt")))) == null) {
            result = "Failed to load OCR output: " + tmp2;
        }
        if (lines != null) {
            TextDialog dialog = ((ImagePanel)this.m_CurrentPanel).getParentDialog() != null ? new TextDialog(((ImagePanel)this.m_CurrentPanel).getParentDialog()) : new TextDialog(((ImagePanel)this.m_CurrentPanel).getParentFrame());
            dialog.setDialogTitle("OCR Result");
            dialog.setContent(Utils.flatten((List)lines, (String)"\n"));
            dialog.setEditable(false);
            dialog.setSize(GUIHelper.getInteger((String)"DefaultSmallDialog.Width", (Integer)600).intValue(), GUIHelper.getInteger((String)"DefaultSmallDialog.Width", (Integer)600).intValue());
            dialog.setLocationRelativeTo((Component)this.m_CurrentPanel);
            dialog.setVisible(true);
        }
        if (tmp != null) {
            FileUtils.delete((File)tmp);
        }
        if (tmp2 != null) {
            FileUtils.delete((File)tmp2);
        }
        return result;
    }
}

