/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.selection;

import adams.gui.core.GUIHelper;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.selection.AbstractSelectionProcessor;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.Component;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class CopyToClipboard
extends AbstractSelectionProcessor {
    private static final long serialVersionUID = -657789971297807743L;
    protected boolean m_Silent;

    public String globalInfo() {
        return "Copies the selection to the system's clipboard.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("silent", "silent", (Object)false);
    }

    public void setSilent(boolean value) {
        this.m_Silent = value;
        this.reset();
    }

    public boolean getSilent() {
        return this.m_Silent;
    }

    public String silentTipText() {
        return "If enabled, user is not prompted with dialog that the selection has been copied.";
    }

    protected void doProcessSelection(ImagePanel panel, Point topLeft, Point bottomRight, int modifiersEx) {
        BufferedImage selection = panel.getCurrentImage().getSubimage(panel.mouseToPixelLocation((Point)topLeft).x, panel.mouseToPixelLocation((Point)topLeft).y, panel.mouseToPixelLocation((Point)bottomRight).x - panel.mouseToPixelLocation((Point)topLeft).x + 1, panel.mouseToPixelLocation((Point)bottomRight).y - panel.mouseToPixelLocation((Point)topLeft).y + 1);
        ClipboardHelper.copyToClipboard((BufferedImage)selection);
        GUIHelper.showInformationMessage((Component)panel, (String)"Selection copied to clipboard!");
    }
}

