/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.fileuse;

import adams.core.io.fileuse.AbstractFileUseCheck;
import adams.flow.transformer.metadata.AbstractMetaDataExtractor;
import adams.flow.transformer.metadata.MetaDataExtractor;
import java.io.File;
import java.util.logging.Level;

public class ImageMetaDataExtractor
extends AbstractFileUseCheck {
    private static final long serialVersionUID = -3766862011655514895L;
    protected AbstractMetaDataExtractor m_Extractor;

    public String globalInfo() {
        return "Uses the specified image reader to load the file for checking the 'in use' state: if reading fails, then it is assumed the file is in use. ";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("extractor", "extractor", (Object)new MetaDataExtractor());
    }

    public void setExtractor(AbstractMetaDataExtractor value) {
        this.m_Extractor = value;
        this.reset();
    }

    public AbstractMetaDataExtractor getExtractor() {
        return this.m_Extractor;
    }

    public String extractorTipText() {
        return "The meta-data extractor to use for checking the 'in use' state.";
    }

    public boolean isInUse(File file) {
        boolean result;
        try {
            this.m_Extractor.extract(file);
            result = false;
        }
        catch (Exception e) {
            if (this.isLoggingEnabled()) {
                this.getLogger().log(Level.SEVERE, "Failed to extract meta-data from: " + file, (Throwable)e);
            }
            result = true;
        }
        return result;
    }
}

