/*
 * Decompiled with CFR 0.152.
 */
package adams.data.barcode.encode;

import adams.flow.transformer.draw.AbstractDrawOperation;
import java.awt.image.BufferedImage;

public abstract class AbstractBarcodeEncoder
extends AbstractDrawOperation {
    private static final long serialVersionUID = 2030827401336384097L;
    protected int m_X;
    protected int m_Y;
    protected int m_Width;
    protected int m_Height;
    protected int m_Margin;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "x", (Object)1, (Number)1, null);
        this.m_OptionManager.add("y", "y", (Object)1, (Number)1, null);
        this.m_OptionManager.add("width", "width", (Object)100, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)100, (Number)1, null);
        this.m_OptionManager.add("margin", "margin", (Object)5, (Number)0, null);
    }

    @Override
    protected String check(BufferedImage image) {
        String result = super.check(image);
        if (result == null) {
            if (this.m_X + this.m_Width - 1 > image.getWidth()) {
                result = "X + Width is larger than image width: " + (this.m_X + this.m_Width) + " > " + image.getWidth();
            } else if (this.m_Y + this.m_Height - 1 > image.getHeight()) {
                result = "Y + Height is larger than image height: " + (this.m_Y + this.m_Height) + " > " + image.getHeight();
            }
        }
        return result;
    }

    public int getX() {
        return this.m_X;
    }

    public void setX(int value) {
        if (value >= 1) {
            this.m_X = value;
            this.reset();
        } else {
            this.getLogger().severe("X must be >= 0, provided: " + value);
        }
    }

    public String xTipText() {
        return "X position of the top-left corner.";
    }

    public int getY() {
        return this.m_Y;
    }

    public void setY(int value) {
        if (value >= 1) {
            this.m_Y = value;
            this.reset();
        } else {
            this.getLogger().severe("Y must be >= 0, provided: " + value);
        }
    }

    public String yTipText() {
        return "Y position of the top-left corner.";
    }

    public int getWidth() {
        return this.m_Width;
    }

    public void setWidth(int value) {
        if (value >= 1) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getLogger().severe("Width must be >= 0, provided: " + value);
        }
    }

    public String widthTipText() {
        return "Width of the barcode in pixels.";
    }

    public int getHeight() {
        return this.m_Height;
    }

    public void setHeight(int value) {
        if (value >= 1) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getLogger().severe("Height must be >= 0, provided: " + value);
        }
    }

    public String heightTipText() {
        return "Height of the barcode in pixels.";
    }

    public int getMargin() {
        return this.m_Margin;
    }

    public void setMargin(int value) {
        if (value >= 0) {
            this.m_Margin = value;
            this.reset();
        } else {
            this.getLogger().severe("Margin must be >= 0, provided: " + value);
        }
    }

    public String marginTipText() {
        return "White margin surrounding the barcode.";
    }
}

