/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.multiimageoperation;

import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.multiimageoperation.AbstractBufferedImageMultiImageOperation;
import adams.data.statistics.StatUtils;
import java.awt.image.BufferedImage;

public class Median
extends AbstractBufferedImageMultiImageOperation {
    private static final long serialVersionUID = 7381673951864996785L;

    public String globalInfo() {
        return "Computes the median from the images (each channel separately).";
    }

    @Override
    public int minNumImagesRequired() {
        return 2;
    }

    @Override
    public int maxNumImagesRequired() {
        return -1;
    }

    protected void check(BufferedImageContainer[] images) {
        super.check((AbstractImageContainer[])images);
        String msg = this.checkSameDimensions((AbstractImageContainer[])images);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
    }

    protected BufferedImageContainer[] doProcess(BufferedImageContainer[] images) {
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        BufferedImage output = BufferedImageHelper.deepCopy((BufferedImage)images[0].toBufferedImage());
        int[][] channels = new int[images.length][];
        int[] val = new int[images.length];
        int[] split = new int[4];
        for (int y = 0; y < images[0].getHeight(); ++y) {
            for (int x = 0; x < images[0].getWidth(); ++x) {
                int i;
                for (i = 0; i < images.length; ++i) {
                    channels[i] = BufferedImageHelper.split((int)images[i].toBufferedImage().getRGB(x, y));
                }
                for (int n = 0; n < 4; ++n) {
                    for (i = 0; i < images.length; ++i) {
                        val[i] = channels[i][n];
                    }
                    split[n] = (int)StatUtils.median((int[])val);
                }
                output.setRGB(x, y, BufferedImageHelper.combine((int[])split));
            }
        }
        result[0] = new BufferedImageContainer();
        result[0].setImage((Object)output);
        return result;
    }
}

