/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.awt.image.BufferedImage;
import java.util.Arrays;

public class LocalMedianFilter
extends AbstractBufferedImageTransformer {
    final int K = 4;

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        int height = img.getHeight();
        int width = img.getWidth();
        int[] pixels = new int[9];
        BufferedImage image = (BufferedImage)img.getImage();
        BufferedImage copy = BufferedImageHelper.deepCopy((BufferedImage)image);
        for (int h = 1; h < height - 1; ++h) {
            for (int w = 1; w < width - 1; ++w) {
                int k = 0;
                for (int x = -1; x < 2; ++x) {
                    for (int y = -1; y < 2; ++y) {
                        pixels[k] = copy.getRGB(w + x, h + y);
                        ++k;
                    }
                }
                image.setRGB(w, h, this.getMedian(pixels));
            }
        }
        result[0] = new BufferedImageContainer();
        result[0].setImage((Object)image);
        return result;
    }

    private int getMedian(int[] pixels) {
        int[] r = new int[9];
        int[] g = new int[9];
        int[] b = new int[9];
        for (int i = 0; i < pixels.length; ++i) {
            int[] channels = BufferedImageHelper.split((int)pixels[i]);
            r[i] = channels[0];
            g[i] = channels[1];
            b[i] = channels[2];
        }
        Arrays.sort(r);
        Arrays.sort(g);
        Arrays.sort(b);
        int[] median = new int[4];
        median[0] = r[4];
        median[1] = g[4];
        median[2] = b[4];
        int result = BufferedImageHelper.combine((int[])median);
        return result;
    }

    public String globalInfo() {
        return null;
    }
}

