/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer.crop;

import adams.data.image.ImageAnchor;
import adams.data.image.transformer.crop.AbstractCropAlgorithm;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class CropBackground
extends AbstractCropAlgorithm {
    private static final long serialVersionUID = -696539737461589970L;
    protected ImageAnchor m_Anchor;

    public String globalInfo() {
        return "Picks the background at the specified anchor position and crops to the smallest possible rectangle.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("anchor", "anchor", (Object)ImageAnchor.TOP_LEFT);
    }

    public void setAnchor(ImageAnchor value) {
        this.m_Anchor = value;
        this.reset();
    }

    public ImageAnchor getAnchor() {
        return this.m_Anchor;
    }

    public String anchorTipText() {
        return "Defines where to pick the background color.";
    }

    protected int scan(BufferedImage img, int from, int to, boolean horizontal, int background) {
        int result = -1;
        int inc = from < to ? 1 : -1;
        if (horizontal) {
            int y = from;
            do {
                for (int x = 0; x < img.getWidth(); ++x) {
                    int color = img.getRGB(x, y) & 0xFFFFFF;
                    if (color == background) continue;
                    result = y;
                    return result;
                }
            } while ((y += inc) != to + inc);
        } else {
            int x = from;
            do {
                for (int y = 0; y < img.getHeight(); ++y) {
                    int color = img.getRGB(x, y) & 0xFFFFFF;
                    if (color == background) continue;
                    result = x;
                    return result;
                }
            } while ((x += inc) != to + inc);
        }
        return result;
    }

    @Override
    protected BufferedImage doCrop(BufferedImage img) {
        int pos;
        int y;
        int x;
        switch (this.m_Anchor) {
            case TOP_LEFT: {
                x = 0;
                y = 0;
                break;
            }
            case TOP_CENTER: {
                x = img.getWidth() / 2 - 1;
                y = 0;
                break;
            }
            case TOP_RIGHT: {
                x = img.getWidth() - 1;
                y = 0;
                break;
            }
            case MIDDLE_LEFT: {
                x = 0;
                y = img.getHeight() / 2 - 1;
                break;
            }
            case MIDDLE_CENTER: {
                x = img.getWidth() / 2 - 1;
                y = img.getHeight() / 2 - 1;
                break;
            }
            case MIDDLE_RIGHT: {
                x = img.getWidth() - 1;
                y = img.getHeight() / 2 - 1;
                break;
            }
            case BOTTOM_LEFT: {
                x = 0;
                y = img.getHeight() - 1;
                break;
            }
            case BOTTOM_CENTER: {
                x = img.getWidth() / 2 - 1;
                y = img.getHeight() - 1;
                break;
            }
            case BOTTOM_RIGHT: {
                x = img.getWidth() - 1;
                y = img.getHeight() - 1;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled anchor: " + (Object)((Object)this.m_Anchor));
            }
        }
        int background = img.getRGB(x, y) & 0xFFFFFF;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Background: " + background + " (" + new Color(background) + ")");
        }
        int top = (pos = this.scan(img, 0, img.getHeight() - 1, true, background)) > -1 ? pos : 0;
        pos = this.scan(img, img.getHeight() - 1, 0, true, background);
        int bottom = pos > -1 ? pos : img.getHeight() - 1;
        pos = this.scan(img, 0, img.getWidth() - 1, false, background);
        int left = pos > -1 ? pos : 0;
        pos = this.scan(img, img.getWidth() - 1, 0, false, background);
        int right = pos > -1 ? pos : img.getWidth() - 1;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("top=" + top + ", left=" + left + ", bottom=" + bottom + ", right=" + right);
        }
        BufferedImage result = img.getSubimage(left, top, right - left + 1, bottom - top + 1);
        return result;
    }
}

