/*
 * Decompiled with CFR 0.152.
 */
package adams.data.lire.features;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.data.statistics.StatUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AutoColorCorrelogram
extends AbstractBufferedImageFeatureGenerator
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 353245595318472893L;

    public String globalInfo() {
        return "Generates features using " + net.semanticmetadata.lire.imageanalysis.AutoColorCorrelogram.class.getName() + ".\nFor more information on the LIRE project, see:\nhttp://code.google.com/p/lire/\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Huang, J.; Kumar, S. R.; Mitra, M.; Zhu, W. & Zabih, R.");
        result.setValue(TechnicalInformation.Field.TITLE, "Image Indexing Using Color Correlograms");
        result.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Computer Society");
        result.setValue(TechnicalInformation.Field.YEAR, "2007");
        result.setValue(TechnicalInformation.Field.HTTP, "http://doi.ieeecomputersociety.org/10.1109/CVPR.1997.609412");
        return result;
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        net.semanticmetadata.lire.imageanalysis.AutoColorCorrelogram features = new net.semanticmetadata.lire.imageanalysis.AutoColorCorrelogram();
        features.extract(image);
        double[] histo = features.getDoubleHistogram();
        HeaderDefinition result = new HeaderDefinition();
        for (int i = 0; i < histo.length; ++i) {
            result.add("AutoColorCorrelogram-" + (i + 1), DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        net.semanticmetadata.lire.imageanalysis.AutoColorCorrelogram features = new net.semanticmetadata.lire.imageanalysis.AutoColorCorrelogram();
        features.extract(image);
        double[] histo = features.getDoubleHistogram();
        List[] result = new List[]{new ArrayList()};
        result[0].addAll(Arrays.asList(StatUtils.toNumberArray((double[])histo)));
        return result;
    }
}

