/*
 * Decompiled with CFR 0.152.
 */
package adams.data.lire.features;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.data.statistics.StatUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OpponentHistogram
extends AbstractBufferedImageFeatureGenerator
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -5934074718170214988L;

    public String globalInfo() {
        return "Generates features using " + net.semanticmetadata.lire.imageanalysis.OpponentHistogram.class.getName() + ".\nFor more information, see:\n" + this.getTechnicalInformation().toString() + "\nFor more information on the LIRE project, see:\nhttp://code.google.com/p/lire/";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "van de Sande, K.E.A. and Gevers, T. and Snoek, C.G.M.");
        result.setValue(TechnicalInformation.Field.TITLE, "Evaluating Color Descriptors for Object and Scene Recognition");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Pattern Analysis and Machine Intelligence, IEEE Transactions on");
        result.setValue(TechnicalInformation.Field.YEAR, "2010");
        result.setValue(TechnicalInformation.Field.MONTH, "September");
        result.setValue(TechnicalInformation.Field.VOLUME, "32");
        result.setValue(TechnicalInformation.Field.NUMBER, "9");
        result.setValue(TechnicalInformation.Field.PAGES, "1582-1596");
        result.setValue(TechnicalInformation.Field.ISSN, "0162-8828");
        result.setValue(TechnicalInformation.Field.HTTP, "http://doi.ieeecomputersociety.org/10.1109/TPAMI.2009.154");
        return result;
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        net.semanticmetadata.lire.imageanalysis.OpponentHistogram features = new net.semanticmetadata.lire.imageanalysis.OpponentHistogram();
        features.extract(image);
        double[] histo = features.getDoubleHistogram();
        HeaderDefinition result = new HeaderDefinition();
        for (int i = 0; i < histo.length; ++i) {
            result.add("OpponentHistogram-" + (i + 1), DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        List[] result = null;
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        net.semanticmetadata.lire.imageanalysis.OpponentHistogram features = new net.semanticmetadata.lire.imageanalysis.OpponentHistogram();
        features.extract(image);
        double[] histo = features.getDoubleHistogram();
        result = new List[]{new ArrayList()};
        result[0].addAll(Arrays.asList(StatUtils.toNumberArray((double[])histo)));
        return result;
    }
}

