/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.core.Utils;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LocatedObjects
extends ArrayList<LocatedObject> {
    private static final long serialVersionUID = 7784285445489902957L;
    public static final String KEY_X = ".x";
    public static final String KEY_Y = ".y";
    public static final String KEY_WIDTH = ".width";
    public static final String KEY_HEIGHT = ".height";
    public static final String KEY_LOCATION = ".location";
    public static final String KEY_COUNT = "count";
    public static final String KEY_INDEX = "index";

    public LocatedObjects() {
    }

    public LocatedObjects(LocatedObjects objects) {
        super(objects);
    }

    public Report toReport(String prefix) {
        Field field;
        Report result = new Report();
        int count = 0;
        int width = ("" + this.size()).length();
        for (LocatedObject obj : this) {
            String countStr = Utils.padLeft((String)("" + ++count), (char)'0', (int)width);
            for (String key : obj.getMetaData().keySet()) {
                Object value = obj.getMetaData().get(key);
                DataType type = value instanceof Double ? DataType.NUMERIC : (value instanceof Boolean ? DataType.BOOLEAN : (value instanceof String ? DataType.STRING : DataType.UNKNOWN));
                field = new Field(prefix + countStr + "." + key, type);
                result.addField((AbstractField)field);
                result.setValue((AbstractField)field, value);
            }
            field = new Field(prefix + countStr + KEY_X, DataType.NUMERIC);
            result.addField((AbstractField)field);
            result.setValue((AbstractField)field, (Object)obj.getX());
            field = new Field(prefix + countStr + KEY_Y, DataType.NUMERIC);
            result.addField((AbstractField)field);
            result.setValue((AbstractField)field, (Object)obj.getY());
            field = new Field(prefix + countStr + KEY_WIDTH, DataType.NUMERIC);
            result.addField((AbstractField)field);
            result.setValue((AbstractField)field, (Object)obj.getWidth());
            field = new Field(prefix + countStr + KEY_HEIGHT, DataType.NUMERIC);
            result.addField((AbstractField)field);
            result.setValue((AbstractField)field, (Object)obj.getHeight());
            field = new Field(prefix + countStr + KEY_LOCATION, DataType.STRING);
            result.addField((AbstractField)field);
            result.setValue((AbstractField)field, (Object)obj.getLocation().getValue());
        }
        field = new Field(prefix + KEY_COUNT, DataType.NUMERIC);
        result.addField((AbstractField)field);
        result.setValue((AbstractField)field, (Object)this.size());
        return result;
    }

    public static LocatedObjects fromReport(Report report, String prefix) {
        LocatedObjects result = new LocatedObjects();
        List fields = report.getFields();
        HashMap groups = new HashMap();
        for (AbstractField field : fields) {
            if (!field.getName().startsWith(prefix)) continue;
            String current = field.getName().substring(0, field.getName().lastIndexOf(46));
            if (!groups.containsKey(current)) {
                groups.put(current, new ArrayList());
            }
            ((List)groups.get(current)).add(field);
        }
        for (String group : groups.keySet()) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            if (group.length() <= prefix.length()) continue;
            meta.put(KEY_INDEX, group.substring(prefix.length()));
            for (AbstractField field : (List)groups.get(group)) {
                if (field.getName().endsWith(KEY_X) || field.getName().endsWith(KEY_Y) || field.getName().endsWith(KEY_WIDTH) || field.getName().endsWith(KEY_HEIGHT)) continue;
                meta.put(field.getName().substring(field.getName().lastIndexOf(46) + 1), report.getValue(field));
            }
            try {
                if (!report.hasValue(group + KEY_X) || !report.hasValue(group + KEY_Y) || !report.hasValue(group + KEY_WIDTH) || !report.hasValue(group + KEY_HEIGHT)) continue;
                int x = report.getDoubleValue(group + KEY_X).intValue();
                int y = report.getDoubleValue(group + KEY_Y).intValue();
                int width = report.getDoubleValue(group + KEY_WIDTH).intValue();
                int height = report.getDoubleValue(group + KEY_HEIGHT).intValue();
                LocatedObject obj = new LocatedObject(null, x, y, width, height, meta.size() > 0 ? meta : null);
                result.add(obj);
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

