/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.Text;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.image.features.Pixels;
import adams.data.image.multiimageoperation.AbstractBufferedImageMultiImageOperation;
import adams.data.image.multiimageoperation.And;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.JAIImageReader;
import adams.data.jai.transformer.Resize;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ArrayProcess;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.BufferedImageFeatureGenerator;
import adams.flow.transformer.BufferedImageMultiImageOperation;
import adams.flow.transformer.BufferedImageTransformer;
import adams.flow.transformer.ImageReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BufferedImageMultiImageOperationTest
extends AbstractFlowTest {
    public BufferedImageMultiImageOperationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("helloworld.png");
        this.m_TestHelper.copyResourceToTmp("helloworld_mask.png");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("helloworld.png");
        this.m_TestHelper.deleteFileFromTmp("helloworld_mask.png");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(BufferedImageMultiImageOperationTest.class);
    }

    public Actor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            Actor[] actors1 = new Actor[5];
            FileSupplier filesupplier2 = new FileSupplier();
            filesupplier2.setOutputArray(true);
            argOption = (AbstractArgumentOption)filesupplier2.getOptionManager().findByProperty("files");
            PlaceholderFile[] files3 = new PlaceholderFile[]{(PlaceholderFile)argOption.valueOf("${TMP}/helloworld.png"), (PlaceholderFile)argOption.valueOf("${TMP}/helloworld_mask.png")};
            filesupplier2.setFiles(files3);
            actors1[0] = filesupplier2;
            ArrayProcess arrayprocess4 = new ArrayProcess();
            argOption = (AbstractArgumentOption)arrayprocess4.getOptionManager().findByProperty("actors");
            Actor[] actors5 = new Actor[2];
            ImageReader imagereader6 = new ImageReader();
            argOption = (AbstractArgumentOption)imagereader6.getOptionManager().findByProperty("reader");
            JAIImageReader jaiimagereader8 = new JAIImageReader();
            imagereader6.setReader((AbstractImageReader)jaiimagereader8);
            actors5[0] = imagereader6;
            BufferedImageTransformer bufferedimagetransformer9 = new BufferedImageTransformer();
            argOption = (AbstractArgumentOption)bufferedimagetransformer9.getOptionManager().findByProperty("transformAlgorithm");
            Resize resize11 = new Resize();
            argOption = (AbstractArgumentOption)resize11.getOptionManager().findByProperty("width");
            resize11.setWidth(((Double)argOption.valueOf("50.0")).doubleValue());
            argOption = (AbstractArgumentOption)resize11.getOptionManager().findByProperty("interpolationType");
            resize11.setInterpolationType((Resize.InterpolationType)argOption.valueOf("NEAREST"));
            bufferedimagetransformer9.setTransformAlgorithm((AbstractBufferedImageTransformer)resize11);
            actors5[1] = bufferedimagetransformer9;
            arrayprocess4.setActors(actors5);
            actors1[1] = arrayprocess4;
            BufferedImageMultiImageOperation bufferedimagemultiimageoperation14 = new BufferedImageMultiImageOperation();
            argOption = (AbstractArgumentOption)bufferedimagemultiimageoperation14.getOptionManager().findByProperty("operation");
            And and16 = new And();
            bufferedimagemultiimageoperation14.setOperation((AbstractBufferedImageMultiImageOperation)and16);
            actors1[2] = bufferedimagemultiimageoperation14;
            BufferedImageFeatureGenerator bufferedimagefeaturegenerator18 = new BufferedImageFeatureGenerator();
            argOption = (AbstractArgumentOption)bufferedimagefeaturegenerator18.getOptionManager().findByProperty("algorithm");
            Pixels pixels20 = new Pixels();
            argOption = (AbstractArgumentOption)pixels20.getOptionManager().findByProperty("converter");
            Text text22 = new Text();
            pixels20.setConverter((AbstractFeatureConverter)text22);
            bufferedimagefeaturegenerator18.setAlgorithm((AbstractBufferedImageFeatureGenerator)pixels20);
            actors1[3] = bufferedimagefeaturegenerator18;
            DumpFile dumpfile23 = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile23.getOptionManager().findByProperty("outputFile");
            dumpfile23.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors1[4] = dumpfile23;
            flow.setActors(actors1);
            argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("flowExecutionListener");
            NullListener nulllistener26 = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener26);
        }
        catch (Exception e) {
            BufferedImageMultiImageOperationTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BufferedImageMultiImageOperationTest.runTest((Test)BufferedImageMultiImageOperationTest.suite());
    }
}

