/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.AbstractBaseString;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class BaseRectangle
extends AbstractBaseString {
    private static final long serialVersionUID = -5853830144343397434L;

    public BaseRectangle() {
        this("0 0 0 0");
    }

    public BaseRectangle(String s) {
        super(s);
    }

    public BaseRectangle(Rectangle location) {
        this(location.x, location.y, location.width, location.height);
    }

    public BaseRectangle(int x, int y, int w, int h) {
        this(x + " " + y + " " + w + " " + h);
    }

    public boolean isValid(String value) {
        String[] parts = (value = value.replaceAll("  ", " ")).split(" ");
        if (parts.length != 4) {
            return false;
        }
        try {
            for (String part : parts) {
                Double.parseDouble(part);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public double[] doubleValue() {
        String[] parts = this.getValue().split(" ");
        double[] result = new double[4];
        if (parts.length != 4) {
            return result;
        }
        for (int i = 0; i < parts.length; ++i) {
            result[i] = Double.parseDouble(parts[i]);
        }
        return result;
    }

    public int[] intValue() {
        String[] parts = this.getValue().split(" ");
        int[] result = new int[4];
        if (parts.length != 4) {
            return result;
        }
        for (int i = 0; i < parts.length; ++i) {
            result[i] = (int)Double.parseDouble(parts[i]);
        }
        return result;
    }

    public Rectangle rectangleValue() {
        int[] parts = this.intValue();
        Rectangle result = new Rectangle(parts[0], parts[1], parts[2], parts[3]);
        return result;
    }

    public Point2D centerValue() {
        Rectangle rect = this.rectangleValue();
        return new Point2D.Double(rect.getCenterX(), rect.getCenterY());
    }

    public String getTipText() {
        return "Rectangle location string.";
    }
}

