/*
 * Decompiled with CFR 0.152.
 */
package adams.data.barcode.decode;

import adams.core.Utils;
import adams.data.barcode.decode.AbstractBarcodeDecoder;
import adams.data.image.AbstractImageContainer;
import adams.data.report.Report;
import adams.data.text.TextContainer;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.qrcode.QRCodeMultiReader;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class MultiQRCode
extends AbstractBarcodeDecoder {
    private static final long serialVersionUID = 6149942254926179607L;
    public static final String REPORT_PARAM_COUNT = "Count";
    public static final String REPORT_PARAM_METADATA_PREFIX = "Metadata-";
    public static final String REPORT_PARAM_DATA = "Data";
    public static final String REPORT_PARAM_FORMAT = "Format";
    public static final String REPORT_PARAM_X = "X";
    public static final String REPORT_PARAM_Y = "Y";
    public static final String REPORT_PARAM_WIDTH = "Width";
    public static final String REPORT_PARAM_HEIGHT = "Height";

    public String globalInfo() {
        return "Decodes all the QR codes using the ZXing library.\nFor more information see:\nhttps://github.com/zxing/zxing";
    }

    @Override
    protected TextContainer doDecode(AbstractImageContainer image) {
        TextContainer result;
        try {
            BufferedImage img = image.toBufferedImage();
            int width = img.getWidth();
            int height = img.getHeight();
            RGBLuminanceSource source = new RGBLuminanceSource(width, height, img.getRGB(0, 0, width, height, null, 0, width));
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            QRCodeMultiReader reader = new QRCodeMultiReader();
            HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
            hints.put(DecodeHintType.TRY_HARDER, null);
            Result[] data = reader.decodeMultiple(bitmap, hints);
            result = new TextContainer();
            Report report = result.getReport();
            report.setNumericValue(REPORT_PARAM_COUNT, (double)data.length);
            for (int i = 0; i < data.length; ++i) {
                report.setStringValue("Data." + (i + 1), data[i].getText());
                report.setStringValue("Format." + (i + 1), data[i].getBarcodeFormat().toString());
                for (Map.Entry d : data[i].getResultMetadata().entrySet()) {
                    if (d.getValue() instanceof Collection) {
                        StringBuilder sb = new StringBuilder();
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        for (Object o : (Collection)d.getValue()) {
                            if (o.getClass().isArray()) {
                                sb.append("[");
                                sb.append(Utils.arrayToString(o));
                                sb.append("]");
                                continue;
                            }
                            sb.append(o.toString());
                        }
                        report.setStringValue(REPORT_PARAM_METADATA_PREFIX + ((ResultMetadataType)d.getKey()).name() + "." + (i + 1), sb.toString());
                        continue;
                    }
                    if (d.getValue().getClass().isArray()) {
                        report.setStringValue(REPORT_PARAM_METADATA_PREFIX + ((ResultMetadataType)d.getKey()).name() + "." + (i + 1), Utils.arrayToString(d.getValue()));
                        continue;
                    }
                    report.setStringValue(REPORT_PARAM_METADATA_PREFIX + ((ResultMetadataType)d.getKey()).name() + "." + (i + 1), d.getValue().toString());
                }
                ResultPoint[] points = data[i].getResultPoints();
                int minX = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int minY = Integer.MAX_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (ResultPoint p : points) {
                    minX = Math.min(minX, (int)p.getX());
                    maxX = Math.max(maxX, (int)p.getX());
                    minY = Math.min(minY, (int)p.getY());
                    maxY = Math.max(maxY, (int)p.getY());
                }
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("minX=" + minX + ", maxX=" + maxX + ", minY=" + minY + ", maxY=" + maxY);
                }
                report.setNumericValue("X." + (i + 1), (double)minX);
                report.setNumericValue("Y." + (i + 1), (double)minY);
                report.setNumericValue("Width." + (i + 1), (double)(maxX - minX + 1));
                report.setNumericValue("Height." + (i + 1), (double)(maxY - minY + 1));
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to decode barcode!", (Throwable)e);
            result = null;
        }
        return result;
    }
}

