/*
 * Decompiled with CFR 0.152.
 */
package adams.data.barcode.decode;

import adams.core.Utils;
import adams.data.barcode.decode.AbstractBarcodeDecoder;
import adams.data.image.AbstractImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.text.TextContainer;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ZXing
extends AbstractBarcodeDecoder {
    private static final long serialVersionUID = 6149942254926179607L;
    public static final String REPORT_PARAM_METADATA_PREFIX = "Metadata-";
    public static final String REPORT_PARAM_FORMAT = "Format";
    public static final String REPORT_PARAM_X = "X";
    public static final String REPORT_PARAM_Y = "Y";
    public static final String REPORT_PARAM_WIDTH = "Width";
    public static final String REPORT_PARAM_HEIGHT = "Height";
    protected boolean m_AutoDetect;
    protected BarcodeFormat[] m_Format;

    public String globalInfo() {
        return "Decodes the data in a barcode using the ZXing library.\nFor more information see:\nhttps://github.com/zxing/zxing";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("autoDetect", "autoDetect", (Object)true);
        this.m_OptionManager.add("format", "format", (Object)new BarcodeFormat[0]);
    }

    public void setAutoDetect(boolean value) {
        this.m_AutoDetect = value;
        this.reset();
    }

    public boolean getAutoDetect() {
        return this.m_AutoDetect;
    }

    public String autoDetectTipText() {
        return "Enable or disable barcode format auto-detection; if disabled, it will attempt to decode using the specified format.";
    }

    public void setFormat(BarcodeFormat[] value) {
        this.m_Format = value;
        this.reset();
    }

    public BarcodeFormat[] getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "Barcode format type to expect.";
    }

    @Override
    protected TextContainer doDecode(AbstractImageContainer image) {
        TextContainer result;
        try {
            BufferedImage img = image.toBufferedImage();
            int width = img.getWidth();
            int height = img.getHeight();
            RGBLuminanceSource source = new RGBLuminanceSource(width, height, img.getRGB(0, 0, width, height, null, 0, width));
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            MultiFormatReader reader = new MultiFormatReader();
            HashMap<DecodeHintType, List<BarcodeFormat>> hints = new HashMap<DecodeHintType, List<BarcodeFormat>>();
            hints.put(DecodeHintType.TRY_HARDER, null);
            if (!this.m_AutoDetect) {
                hints.put(DecodeHintType.POSSIBLE_FORMATS, Arrays.asList(this.m_Format));
            }
            Result data = reader.decode(bitmap, hints);
            result = new TextContainer();
            result.setContent((Object)data.getText());
            Report report = result.getReport();
            report.addField((AbstractField)new Field(REPORT_PARAM_FORMAT, DataType.STRING));
            report.setStringValue(REPORT_PARAM_FORMAT, data.getBarcodeFormat().toString());
            for (Map.Entry d : data.getResultMetadata().entrySet()) {
                report.addField((AbstractField)new Field(REPORT_PARAM_METADATA_PREFIX + ((ResultMetadataType)d.getKey()).name(), DataType.STRING));
                if (d.getValue() instanceof Collection) {
                    StringBuilder sb = new StringBuilder();
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    for (Object o : (Collection)d.getValue()) {
                        if (o.getClass().isArray()) {
                            sb.append("[");
                            sb.append(Utils.arrayToString(o));
                            sb.append("]");
                            continue;
                        }
                        sb.append(o.toString());
                    }
                    report.setStringValue(REPORT_PARAM_METADATA_PREFIX + ((ResultMetadataType)d.getKey()).name(), sb.toString());
                    continue;
                }
                if (d.getValue().getClass().isArray()) {
                    report.setStringValue(REPORT_PARAM_METADATA_PREFIX + ((ResultMetadataType)d.getKey()).name(), Utils.arrayToString(d.getValue()));
                    continue;
                }
                report.setStringValue(REPORT_PARAM_METADATA_PREFIX + ((ResultMetadataType)d.getKey()).name(), d.getValue().toString());
            }
            ResultPoint[] points = data.getResultPoints();
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (ResultPoint p : points) {
                minX = Math.min(minX, (int)p.getX());
                maxX = Math.max(maxX, (int)p.getX());
                minY = Math.min(minY, (int)p.getY());
                maxY = Math.max(maxY, (int)p.getY());
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("minX=" + minX + ", maxX=" + maxX + ", minY=" + minY + ", maxY=" + maxY);
            }
            report.setNumericValue(REPORT_PARAM_X, (double)minX);
            report.setNumericValue(REPORT_PARAM_Y, (double)minY);
            report.setNumericValue(REPORT_PARAM_WIDTH, (double)(maxX - minX + 1));
            report.setNumericValue(REPORT_PARAM_HEIGHT, (double)(maxY - minY + 1));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to decode barcode!", (Throwable)e);
            result = null;
        }
        return result;
    }
}

