/*
 * Decompiled with CFR 0.152.
 */
package adams.data.barcode.encode;

import adams.data.barcode.encode.AbstractBarcodeEncoder;
import adams.data.image.BufferedImageContainer;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.UPCAWriter;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class UPCA
extends AbstractBarcodeEncoder {
    private static final long serialVersionUID = -5065848369849665652L;
    protected String m_Digits;

    public String globalInfo() {
        return "Draws a UPCA barcode at a specified location and size.Digits must be 11 (checksum gets calculated) or 12 (incl. checksum)";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("digits", "digits", (Object)"012345678905");
    }

    public String getDigits() {
        return this.m_Digits;
    }

    protected String isValidCode(String code) {
        if (code == null || code.isEmpty()) {
            return "Digits must not be null or empty.";
        }
        if (!code.matches("\\d+")) {
            return "Value must not contain non-numeric characters, provided: " + code;
        }
        if (code.length() == 11) {
            return null;
        }
        if (code.length() != 12) {
            return "11 or 12 digits must be present: " + code + " (=" + code.length() + ")";
        }
        int sum = 0;
        for (int i = 0; i < 11; ++i) {
            int c = Integer.parseInt(code.substring(i, i + 1));
            sum += c * (i % 2 == 0 ? 1 : 3);
        }
        int check = 10 - sum % 10;
        if (check != Integer.parseInt(code.substring(11, 12))) {
            return "Checksum digits differ: expected=" + check + ", found=" + code.substring(11, 12);
        }
        return null;
    }

    public void setDigits(String value) {
        String check = this.isValidCode(value);
        if (check == null) {
            this.m_Digits = value;
            this.reset();
        } else {
            this.getLogger().severe(check);
        }
    }

    public String digitsTipText() {
        return "Digits to be encoded.";
    }

    @Override
    protected String doDraw(BufferedImageContainer image) {
        String result = null;
        try {
            UPCAWriter writer = new UPCAWriter();
            HashMap<EncodeHintType, Integer> hints = new HashMap<EncodeHintType, Integer>();
            hints.put(EncodeHintType.MARGIN, this.m_Margin);
            BitMatrix matrix = writer.encode(this.m_Digits, BarcodeFormat.UPC_A, this.m_Width, this.m_Height, hints);
            for (int y = this.m_Y; y < this.m_Height; ++y) {
                for (int x = this.m_X; x < this.m_Width; ++x) {
                    ((BufferedImage)image.getImage()).setRGB(x, y, matrix.get(x, y) ? 0 : 0xFFFFFF);
                }
            }
        }
        catch (WriterException e) {
            result = e.getMessage();
        }
        return result;
    }
}

