/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayHistogram;
import adams.data.statistics.StatUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.j3d.color.ColorUtils;

public class Histogram
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected HistogramType m_HistogramType;
    protected int m_NumBins;
    protected boolean m_GroupChannels;

    public String globalInfo() {
        return "Turns an image into a histogram.\nIn case of an 8-bit histogram, the image must already be converted to a gray image.\nThe number of bins per channel can be chosen as well (1-256).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("histo-type", "histogramType", (Object)HistogramType.RGB);
        this.m_OptionManager.add("num-bins", "numBins", (Object)256, (Number)1, (Number)256);
        this.m_OptionManager.add("group-channels", "groupChannels", (Object)false);
    }

    public void setHistogramType(HistogramType value) {
        this.m_HistogramType = value;
        this.reset();
    }

    public HistogramType getHistogramType() {
        return this.m_HistogramType;
    }

    public String histogramTypeTipText() {
        return "The type of histogram to generate.";
    }

    public void setNumBins(int value) {
        if (this.getOptionManager().isValid("numBins", (Number)value)) {
            this.m_NumBins = value;
            this.reset();
        }
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public String numBinsTipText() {
        return "The number of bins per channel (1-256).";
    }

    public void setGroupChannels(boolean value) {
        this.m_GroupChannels = value;
        this.reset();
    }

    public boolean getGroupChannels() {
        return this.m_GroupChannels;
    }

    public String groupChannelsTipText() {
        return "If enabled, grouping is by channel rather than by bin.";
    }

    protected String[] getChannelSuffixes() {
        switch (this.m_HistogramType) {
            case GRAY: {
                return new String[]{"_"};
            }
            case RGB: {
                return new String[]{"_r_", "_g_", "_b_"};
            }
            case YUV: {
                return new String[]{"_y_", "_u_", "_v_"};
            }
            case YIQ: {
                return new String[]{"_y_", "_i_", "_q_"};
            }
            case HSV: {
                return new String[]{"_h_", "_s_", "_v_"};
            }
        }
        throw new IllegalStateException("Unhandled histogram type: " + (Object)((Object)this.m_HistogramType));
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        int numAtts = this.m_NumBins;
        String[] channels = this.getChannelSuffixes();
        if (this.m_GroupChannels) {
            for (String channel : channels) {
                for (int i = 0; i < numAtts; ++i) {
                    result.add("histo" + channel + (i + 1), DataType.NUMERIC);
                }
            }
        } else {
            for (int i = 0; i < numAtts; ++i) {
                for (String channel : channels) {
                    result.add("histo" + channel + (i + 1), DataType.NUMERIC);
                }
            }
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        int n;
        int i;
        Integer[][] p;
        double[] values;
        BufferedImage image;
        List[] result = null;
        int size = img.getHeight() * img.getWidth();
        switch (this.m_HistogramType) {
            case GRAY: {
                image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)10);
                values = new double[this.m_NumBins];
                p = new Integer[1][size];
                break;
            }
            case RGB: 
            case YUV: 
            case YIQ: 
            case HSV: {
                image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
                values = new double[this.m_NumBins * 3];
                p = new Integer[3][size];
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled histogram type: " + (Object)((Object)this.m_HistogramType));
            }
        }
        int[][] pixels = BufferedImageHelper.getRGBPixels((BufferedImage)image);
        float[] rgb = new float[3];
        float[] conv = new float[3];
        switch (this.m_HistogramType) {
            case GRAY: {
                for (i = 0; i < size; ++i) {
                    p[0][i] = pixels[i][0];
                }
                break;
            }
            case RGB: {
                for (i = 0; i < size; ++i) {
                    for (n = 0; n < 3; ++n) {
                        p[n][i] = pixels[i][n];
                    }
                }
                break;
            }
            case YUV: {
                for (i = 0; i < size; ++i) {
                    for (n = 0; n < 3; ++n) {
                        rgb[n] = (float)((double)pixels[i][n] / 255.0);
                    }
                    ColorUtils.convertRGBtoYUV((float[])rgb, (float[])conv);
                    for (n = 0; n < 3; ++n) {
                        p[n][i] = (int)((double)conv[n] * 255.0);
                    }
                }
                break;
            }
            case YIQ: {
                for (i = 0; i < size; ++i) {
                    for (n = 0; n < 3; ++n) {
                        rgb[n] = (float)((double)pixels[i][n] / 255.0);
                    }
                    ColorUtils.convertRGBtoYIQ((float[])rgb, (float[])conv);
                    for (n = 0; n < 3; ++n) {
                        p[n][i] = (int)((double)conv[n] * 255.0);
                    }
                }
                break;
            }
            case HSV: {
                for (i = 0; i < size; ++i) {
                    for (n = 0; n < 3; ++n) {
                        rgb[n] = (float)((double)pixels[i][n] / 255.0);
                    }
                    ColorUtils.convertRGBtoHSV((float[])rgb, (float[])conv);
                    for (n = 0; n < 3; ++n) {
                        p[n][i] = (int)((double)conv[n] * 255.0);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled histogram type: " + (Object)((Object)this.m_HistogramType));
            }
        }
        ArrayHistogram histogram = new ArrayHistogram();
        histogram.setNumBins(this.m_NumBins);
        histogram.setNormalize(false);
        histogram.setBinCalculation(ArrayHistogram.BinCalculation.MANUAL);
        switch (this.m_HistogramType) {
            case GRAY: {
                histogram.add(p[0]);
                AbstractArrayStatistic.StatisticContainer cont = histogram.calculate();
                for (i = 0; i < this.m_NumBins; ++i) {
                    values[i] = (Double)cont.getCell(0, i);
                }
                break;
            }
            case RGB: 
            case YUV: 
            case YIQ: 
            case HSV: {
                AbstractArrayStatistic.StatisticContainer cont;
                for (n = 0; n < 3; ++n) {
                    histogram.clear();
                    histogram.add(p[n]);
                    cont = histogram.calculate();
                    for (i = 0; i < this.m_NumBins; ++i) {
                        values[i * 3 + n] = (Double)cont.getCell(0, i);
                    }
                }
                break;
            }
        }
        String[] channels = this.getChannelSuffixes();
        result = new List[]{new ArrayList()};
        if (this.m_GroupChannels) {
            for (n = 0; n < channels.length; ++n) {
                for (i = 0; i < this.m_NumBins; ++i) {
                    result[0].add(values[i * channels.length + n]);
                }
            }
        } else {
            result[0].addAll(Arrays.asList(StatUtils.toNumberArray((double[])values)));
        }
        return result;
    }

    public static enum HistogramType implements EnumWithCustomDisplay<HistogramType>
    {
        GRAY("Gray"),
        RGB("RGB"),
        YUV("YUV"),
        YIQ("YIQ"),
        HSV("HSV");

        private String m_Display;
        private String m_Raw;

        private HistogramType(String display) {
            this.m_Display = display;
            this.m_Raw = super.toString();
        }

        public String toDisplay() {
            return this.m_Display;
        }

        public String toRaw() {
            return this.m_Raw;
        }

        public String toString() {
            return this.toDisplay();
        }

        public HistogramType parse(String s) {
            return HistogramType.valueOf((AbstractOption)null, s);
        }

        public static String toString(AbstractOption option, Object object) {
            return ((HistogramType)((Object)object)).toRaw();
        }

        public static HistogramType valueOf(AbstractOption option, String str) {
            HistogramType result = null;
            try {
                result = HistogramType.valueOf(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                for (HistogramType dt : HistogramType.values()) {
                    if (!dt.toDisplay().equals(str)) continue;
                    result = dt;
                    break;
                }
            }
            return result;
        }
    }
}

