/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.moments;

import adams.data.image.BufferedImageContainer;
import adams.data.image.moments.AbstractMoment;
import java.awt.Color;
import java.awt.image.BufferedImage;

public abstract class AbstractBufferedImageMoment
extends AbstractMoment<BufferedImageContainer> {
    private static final long serialVersionUID = 1665590865743934991L;
    protected Color m_BackgroundValue;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("background-value", "backgroundValue", (Object)Color.WHITE);
    }

    public void setBackgroundValue(Color value) {
        this.m_BackgroundValue = value;
        this.reset();
    }

    public String backgroundValueTipText() {
        return "The background color to use.";
    }

    public Color getBackgroundValue() {
        return this.m_BackgroundValue;
    }

    @Override
    protected boolean check(BufferedImageContainer img) {
        return true;
    }

    @Override
    public boolean[][] imageToMatrix(BufferedImageContainer img) {
        return AbstractBufferedImageMoment.imageToMatrix(img, this.m_BackgroundValue);
    }

    public static boolean[][] imageToMatrix(BufferedImageContainer img, Color background) {
        BufferedImage image = img.toBufferedImage();
        int bg = background.getRGB();
        boolean[][] result = new boolean[image.getHeight()][image.getWidth()];
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                result[y][x] = image.getRGB(x, y) != bg;
            }
        }
        return result;
    }
}

