/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.multiimageoperation;

import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.multiimageoperation.AbstractBufferedImageMultiImageOperation;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class And
extends AbstractBufferedImageMultiImageOperation {
    private static final long serialVersionUID = 7381673951864996785L;

    public String globalInfo() {
        return "Performs a logical AND on the binary pixels of the images.\nConverts images automatically to type BufferedImage.TYPE_BYTE_BINARY.";
    }

    @Override
    public int minNumImagesRequired() {
        return 2;
    }

    @Override
    public int maxNumImagesRequired() {
        return -1;
    }

    protected void check(BufferedImageContainer[] images) {
        super.check((AbstractImageContainer[])images);
        String msg = this.checkSameDimensions((AbstractImageContainer[])images);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
    }

    protected BufferedImageContainer[] doProcess(BufferedImageContainer[] images) {
        int i;
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        BufferedImage[] img = new BufferedImage[images.length];
        for (i = 0; i < images.length; ++i) {
            img[i] = BufferedImageHelper.convert((BufferedImage)((BufferedImage)images[i].getImage()), (int)12);
        }
        BufferedImage output = BufferedImageHelper.deepCopy((BufferedImage)img[0]);
        int match = Color.BLACK.getRGB();
        int mismatch = Color.WHITE.getRGB();
        for (int y = 0; y < images[0].getHeight(); ++y) {
            for (int x = 0; x < images[0].getWidth(); ++x) {
                int val = img[0].getRGB(x, y);
                boolean same = true;
                for (i = 1; i < img.length; ++i) {
                    if (val == img[i].getRGB(x, y)) continue;
                    same = false;
                }
                output.setRGB(x, y, same ? match : mismatch);
            }
        }
        result[0] = new BufferedImageContainer();
        result[0].setImage((Object)output);
        return result;
    }
}

